function proots = root_names(p)
%ROOT_NAMES Find root names of an array of variable names
%
% proot = root_names(p) finds the character bases of the variable names and
% returns them as a cell array of strings. For each term with no basis
% (e.g., a number), the whole term is returned.
%
% Character bases may also have one or more zeros at the end (these
% are invalid indices for MATLAB arrays).
%
% Example:
%   p = polysym('x',3); % Returns array with terms like 'x2_3'
%   root_names(p)

pstr = cellstr(p);
proots = regexp(pstr,'[a-zA-Z]*','match');

if ~isempty(proots)
    
    for ii=1:numel(proots)
        if isempty(proots{ii})
            proots{ii} = pstr(ii);
        end
    end
    
    proots = [proots{:}];
end
