function proot = root_name(p)
%ROOT_NAME Find root name of an array of variable names
%
% proot = root_name(p) finds the common part of the variable names in an
% array and returns it as a string.
%
% Example:
%   p = polysym('x',3); % Returns array with terms like 'x2_3'
%   root_name(p)

pc = p.cellstr;
pfirst = pc{1};

for ii=1:length(pc{1})
    proot = pfirst(1:ii);
    matches = cellfun(@(x) ~isempty(x),strfind(pc,proot));
    
    if ~all(matches(:))
        proot = proot(1:end-1);
        break
    end
end
