function obj = parens(obj1)
%PARENS Put parentheses around strings in an array of POLYSYM objects.
%
% obj = parens(obj) inputs OBJ, an array of POLYSYM objects, and puts
% parentheses around the string in each object.
%
% Example:
%  parens(polysym(0))
%   ans = 
%
%       '(0)'
%
% See also TIMES, MTIMES, LDIVIDE, RDIVIDE.


obj = obj1;
for k=1:numel(obj1)
    if iszero(obj1(k))
        obj(k).Value = '(0)';
    else
        obj(k).Value = ['(',obj1(k).Value,')'];
    end
end
