function tf = isvariablename(p)
%ISVARIABLENAME Determine whether each component is a valid Bertini
%variable name
%
% Source: "Numerically solving polynomial systems with Bertini", Appendix B

tf = false(size(p));
S = cellstr(p);
for ii=1:numel(S)
    [~,~,~,matchstring] = regexp(S{ii},'[a-zA-Z][a-zA-Z0-9_\[\]]*');
    tf(ii) = strcmp(S{ii},matchstring);
end