function tf = isnumber(p)
%ISNUMBER Determine whether each component is a valid expression for a
%number in Bertini
%
% See "Numerically solving polynomial systems with Bertini", Appendix B

tf = false(size(p));
S = cellstr(p);
for ii=1:numel(S)
    [~,~,~,matchstring] = regexp(S{ii}, ...
        '([0-9]+[\.]?([0-9]*)?([eE][-+]?[0-9]+)?)|([0-9]*\.[0-9]+([eE][-+]?[0-9]+)?)');
    tf(ii) = strcmp(S{ii},matchstring);
end