function obj = power(obj1,n)
% Overloaded array power (.^) function. 
%
% OBJ = POWER(OBJ1,N) inputs OBJ1, an array of POLYSYM objects, and
% N, an array of integers. Returns OBJ, a POLYSYM object representing OBJ1.^N.
%
% Example:
%       s = polysym({'s', 't'});
%       disp(s.^2)
%         's^2'    't^2'
%
% See also ISZERO, ISONE.

validateattributes(n,{'numeric'},{'integer'},'power','n',2)

obj1 = polysym(obj1);
[obj1,n] = makeSameSize(obj1,n);

obj = obj1;
for k=1:numel(n)
    switch n(k)
        case 0
            obj(k)=polysym('1');
        case 1
            obj(k)=obj1(k);
        otherwise
            if iszero(obj1(k))
                obj(k)=polysym('0');
            elseif isone(obj1(k))
                obj(k)=obj1(k);
            else
                s = checkParens(obj1(k));
                obj(k).Value = [s,'^',num2str(n(k))];
            end
    end
end
