function y = polyval(p,x)
%POLYVAL Evaluate polynomial (overloaded for POLYSYM class).
%
%   Y = POLYVAL(P,X) returns the value of a polynomial P evaluated at X. P
%   is a vector of length N+1 whose elements are the coefficients of the
%   polynomial in descending powers.
%
%       Y = P(1)*X^N + P(2)*X^(N-1) + ... + P(N)*X + P(N+1)
%
%   If X is a matrix or vector, the polynomial is evaluated at all
%   points in X.  See POLYVALM for evaluation in a matrix sense.

y = polysym(zeros(size(x)));

% Calculate using Horner's method.
nc = length(p);
if nc>0 && ~isempty(y)
    y(:) = p(1);
end

for i=2:nc
    y = x .* y + p(i);
end
