function outstr = pi_UC(instr)
%PI_UC Convert the constant 'pi' to 'Pi' for Bertini input
%
% outstr = pi_UC(instr) inputs a string, searches for the constant 'pi' and
% replaces it by 'Pi'. If 'pi' is embedded in a variable name, it is left
% alone.
%
% See also: format_imag
outstr = instr;

% Find variable names
[matchstart,matchstring] = regexp(outstr,'[a-zA-Z][a-zA-Z0-9_]*','start','match');

% Locate names that are equal to 'pi'
for ii=1:numel(matchstart)
    if strcmp(matchstring{ii},'pi')
        idx = matchstart(ii);
        outstr(idx:idx+1) = 'Pi';
    end
end