function obj = mtimes(obj1,obj2)
% Overloaded matrix multiplication (*) function
%
% OBJ=MTIMES(OBJ1,OBJ2) inputs two arrays of POLYSYM objects representing
% matrices and returns their product.
%
% Example:
%  s = polysym({'a','b'; 'c','d'});
%  t = polysym({'p','q'; 'r','s'});
%  disp(s*t)
%   'a*p+b*r'    'a*q+b*s'
%   'c*p+d*r'    'c*q+d*s'
%
% See also TIMES.


obj1 = polysym(obj1); obj2 = polysym(obj2);

if isscalar(obj1)
    obj = obj2;
    for k=1:numel(obj2)
        obj(k) = obj1.*obj(k);
    end
elseif isscalar(obj2)
    obj = obj1;
    for k=1:numel(obj1)
        obj(k) = obj(k).*obj2;
    end
else
    [n1,m1] = size(obj1);
    [n2,m2] = size(obj2);
    assert(m1==n2,'polysym:mtimes:innerdim','Inner matrix dimensions must agree.')
    
    obj(n1,m2) = polysym;
    for k=1:n1
        for p=1:m2
            obj(k,p) = sum(obj1(k,:).*obj2(:,p).',2);
        end
    end
end
