function obj = ldivide(obj1,obj2)
% Overloaded left array division (.\) function
%
% OBJ=OBJ1.\OBJ2 inputs two arrays of POLYSYM objects and returns
% another in which OBJ(i) now represents OBJ2(i)/OBJ1(i). If either OBJ1 or
% OBJ2 is a scalar, it is expanded to an array of the same dimensions as
% the other input.
%
% Example:
%  s = polysym({'s'});
%  t = polysym({'t'});
%  disp(t.\s)
%   's/t'
%
% See also RDIVIDE.

obj1 = polysym(obj1); obj2 = polysym(obj2);
[obj1,obj2] = makeSameSize(obj1,obj2);

% Do division operation
obj = obj2;
for k=1:numel(obj1)
    if iszero(obj1(k))
        error('polysym:ldivide:DivideByZero', ...
            'Division by zero attempted.')
    elseif ~iszero(obj2(k)) && ~isone(obj1(k))
        s1 = checkParens(obj1(k));
        s2 = checkParens(obj2(k));
        obj(k).Value = [s2,'/',s1];
    end
end
end% ldivide
