function tf = isempty(obj)
% Determines which members of a POLYSYM object are empty.
%
% TF = ISEMPTY(OBJ) inputs a POLYSYM object and returns a logical value TRUE where
% the object is empty and FALSE otherwise.
%
% Example:
%   obj = polysym.empty;
%   isempty(obj)
% 
%   ans =
% 
%        1
%
% See also ISONE.

tf = numel(obj)==0;
