function obj = horzcat(varargin)
% HORZCAT horizontal concatenation
%
% obj = horzcat(varargin) concatenates polysym objects in a way that would
% make sense for their contents.
%
% Example:
%   [polysym.empty polysym polysym('x')]% same as polysym([[], {'0'},{'x'}])

% Eliminate default (polysym) and empty polysym objects.
I = cellfun(@(x) ~isempty(x),varargin);
v = varargin(I);

% Convert all the components to polysym
v = cellfun(@polysym,v,'UniformOutput',false);

% Convert to cell array of strings for concatenation
S = cellfun(@cellstr,v,'UniformOutput',false);
obj = polysym(horzcat(S{:}));