function instr = format_imag(instr)
%FORMAT_IMAG Correct the format of imaginary numbers for Bertini input
%
% outstr = format_imag(instr) inputs a string and replaces instances of 'i'
% or '1i' with I, as long as they are not part of a variable name.
%
% See also: pi_UC

%0+... : remove 0+ (but not if it's part of a number or variable)
instr = regexprep(instr,'(?<![\w\.])0\+','');  

%i following a number and not preceding a number or character -> *I
instr = regexprep(instr,'(?<=[0-9]+)i(?!\w)','*I');

%isolated i -> I
instr = regexprep(instr,'(?<!\w)i(?!\w)','I');
% 
% %special case: 1*I -> I
% if strcmp(strtrim(instr),'1*I')
%     instr = 'I';
% end