function [matchstr,remainder] = find_real_numbers(str)
%FIND_REAL_NUMBERS Find real parts of complex numbers in a string.
%
% [matchstr,remainder] = find_real_numbers(p) takes a string and returns
% all real numbers as a cell array of strings in MATCHSTR. The rest of
% the string is returned in REMAINDER.
%
% The function looks for real numbers in decimal or scientific notation.
% Examples of acceptable numbers are '3.14159', '3', '.3', '1.4e-10', '-
% 1.4'; unacceptable numbers include '1e' and 'e10'. If a string like '-1.4
% + 4*I' is submitted, the matches {'-1.4','4'} will be returned. This
% function is only intended for use by polysym methods that should call
% FIND_IMAG_NUMBERS first and check the remainder for anomalies.
%
% Any white space in the matches or the remainder is removed.
%
% See also: find_imag_numbers, write_number
% 
% Example:
%   str = 1e-24 - 10 * I;
%   [matchstr,remainder] = find_real_numbers(str);

e1 = '[+-]?\s*+';                       % optional sign in front
e2 = '(?>\d++\.?+\d*+|\d*+\.?+\d++)';   % digits with optional decimal
e3 = '(e[\+\-]?\d+)?';                  % optional exponent
e4 = '(?!\s*\*\s*I)';                   % not multiplied by I (square root of -1)
expr = [e1,e2,e3,e4];

[matchstr,remainder] = regexpi(str, expr, 'match','split');

remainder = deblank(remainder);
remainder = [remainder{:}];
    
for ii=1:numel(matchstr)
    str = matchstr{ii};
    matchstr{ii} = str(~isspace(str));    % Remove white space
end
