function tf = eq(p1,p2)
%EQ Test for equality of POLYSYM arrays
%   
%   p1 == p2 checks whether a POLYSYM array P1 is equal to another array
%   P2. P2 can be a numeric, cell, SYM or POLYSYM array.
%
%   The two arrays must have the same dimensions, unless P2 is a scalar.
%   The result is a logical array the same size as P1 with values true (1)
%   or false (0).
%
%   Examples:
%       polysym(eye(2)) == ones(2)
%       polysym(eye(2)) == 1
%       polysym(eye(2)) == {'1', '0'; '0', '1'}

tf = strcmp(cellstr(p1),cellstr(p2));
