function p = ctranspose(p)
%CTRANSPOSE Non-conjugate transpose
%
% p = p' inputs an array P, calculates its transpose (P.') and returns it
% along with a warning. Applied to numeric classes, ctranspose calculates
% the complex conjugate transpose, but POLYSYM class does not support
% complex conjugation.
%
% See also: ctranspose

p = p.';

warning('polysym:ctranspose:noConjugate', ...
    ['You tried to calculate a complex conjugate transpose (e.g., p''). ', ...
    'The POLYSYM class does not support complex conjugation, ', ...
    'so the non-conjugate transpose (.'') was substituted. ', ...
    'If this is correct, consider changing ('') to (.'') in your code.'])