function obj = cos(obj)
% Overloaded cosine function
%
% obj = cos(obj) inputs an array of POLYSYM objects and returns their cosines.
%
% Generally these are just strings, e.g., 'cos(x)'. However, the cosine
% of a zero is returned as 1.
%
% Example:
%   polysyms x
%   cos(x)
%
% See also SIN, EXP.

for k=1:numel(obj)
    if iszero(obj(k))
        obj(k).Value = '1';
    else
        obj(k).Value = ['cos(',obj(k).Value,')'];
    end
end