% @POLYSYM
%
% Files
%   assemble_components - See if a possible array has all the indices
%   cellstr             - Convert array of POLYSYM objects to cell array of strings
%   char_base           - Find character strings in an array of variable names
%   common_name         - Find common part of an array of variable names
%   cos                 - Overloaded cosine function
%   cross               - Vector cross product
%   ctranspose          - Non-conjugate transpose
%   cumprod             - Cumulative product
%   cumsum              - Cumulative sum
%   diag                - Diagonal matrices and diagonals of a matrix.
%   diff                - Differences between adjacent terms
%   disp                - Overloaded DISP for a POLYSYM object.
%   double              - Convert polysym array to double precision
%   eq                  - Test for equality of POLYSYM arrays
%   exp                 - Overloaded exponential function
%   find_imag_numbers   - Find imaginary parts of complex numbers in a string.
%   find_real_numbers   - Find real parts of complex numbers in a string.
%   format_array        - Represent polysym array as formatted char array
%   format_equations    - Create cell array of strings representing equations
%   format_imag         - Correct the format of imaginary numbers for Bertini input
%   horzcat             - horizontal concatenation
%   isempty             - Determines which members of a POLYSYM object are empty.
%   isone               - Determines which members of a POLYSYM object represent the
%   iszero              - Determines which members of a POLYSYM object represent the
%   ldivide             - Overloaded left array division (.\) function
%   minus               - Overloaded minus (-) function
%   mldivide            - Overloaded left-matrix division (\), restricted to scalar divisor
%   mpower              - Overloaded array power (^) function restricted to scalar integer power
%   mrdivide            - Overloaded right-matrix division (/), restricted to scalar divisor
%   mtimes              - Overloaded matrix multiplication (*) function
%   ne                  - Test for ineuality of POLYSYM arrays
%   pi_UC               - Convert the constant 'pi' to 'Pi' for Bertini input
%   plus                - Overloaded plus (+) function
%   polysym             - Polynomial string class
%   power               - Overloaded array power (.^) function. 
%   prod                - Overloaded product of elements.
%   put_in_arrays       - Collect components into arrays, where appropriate.
%   rdivide             - Overloaded right array division (./) function
%   real_imag           - Separate real and imaginary parts of complex numbers.
%   sin                 - Overloaded sine function
%   sort                - Sort array elements in ascending or descending order
%   sum                 - Return sum of POLYSYM elements
%   sym                 - Convert POLYSYM object to SYM
%   symvar              - Determine symbolic variables in expression
%   times               - Overloaded element-by-element multiplication (.*) function
%   trace               - Sum of diagonal elements
%   tril                - Lower triangular part of matrix
%   triu                - Upper triangular part of matrix
%   uminus              - Overloaded unary minus (-) function
%   vertcat             - Vertical concatenation
%   vpa                 - Variable-precision arithmetic
%   polyval             - Evaluate polynomial (overloaded for POLYSYM class).
