function incidence_info = read_incidence_matrix(poly_sys)
%READ_INCIDENCE_MATRIX Read information on components containing given
%points
%
% incidence_info = poly_sys.read_incidence_matrix reads the file
% incidence_matrix and returns the structure INCIDENCE_INFO.
%
%   INCIDENCE_INFO has the fields
%       codims -        nonempty codims (vector of integers)
%       ncomponents -   number of components per codim (vector of integers)
%       ismember -      logical array with a column for each point and a
%                       row for each component. A given element is
%                       marked true if that point is in that component. 
%
% Example:
%
% See also: solve, read_raw_data, match_solutions
%
% Source: Appendix D of "Numerically solving polynomial systems with
% Bertini", by Daniel J. Bates, Jonathan D. Haunstein, Andrew J. Sommese
% and Charles W. Wampler (SIAM 2013)

% Finite solutions
fname = poly_sys.fullname('incidence_matrix');
[fid,msg] = fopen(fname,'r');
assert(fid >= 3,'BertiniLab:read_incidence_matrix:openError', msg)

ncodim = fscanf(fid,'%d\n',1);

y = fscanf(fid,'%d',[2 ncodim]).';
codims = y(:,1);
ncomponents = y(:,2);
fgetl(fid);
npoints = fscanf(fid,'%d',1);
fgetl(fid);
ismember = fscanf(fid,'%d',[sum(ncomponents) npoints]);
fclose(fid);

incidence_info = struct('codims',codims,'ncomponents',ncomponents, ...
    'ismember',logical(ismember));

