function y = read_data_point(fid,nComponents)
%READ_DATA_POINT Read one point from a Bertini output file
%
% y = BertiniLab.read_data_point(fid,nComponents) inputs FID, a file
% identifier; and NCOMPONENTS, the number of components the point has.
% Returns Y, a POLYSYM representation of a complex number.

y = polysym.find_real_numbers(fgetl(fid));
y = polysym(repmat(y,nComponents,1));

for ii=2:nComponents
    y(ii,:) = polysym.find_real_numbers(fgetl(fid));
end

if size(y,2) > 1
    y = y(:,1)+y(:,2)*1i;
end