function name = find_reader(fname)
%FIND_READER Find the name of the reader for a given file name
%
% name = BertiniLab.find_reader(fname) inputs FNAME, a string; if the
% appropriate method is found to read it, returns the name of the method.
% Otherwise, returns an error.

% Create a structure of reading lists
reading_list.read_raw_data = {'raw_data'};
reading_list.read_solutions = {'raw_solutions','raw_data','nonsingular_solutions','singular_solutions', ...
    'finite_solutions','real_solutions','real_finite_solutions'};
reading_list.read_main_data = {'main_data'};
reading_list.read_witness_data = {'witness_data'};
reading_list.read_incidence_matrix = {'incidence_matrix'};

fn = fieldnames(reading_list);
for ii=1:numel(fn)
    if any(strcmp(reading_list.(fn{ii}),fname))
        name = fn{ii};
        return
    end
end
error('BertiniLab:find_reader:invalidName',['File ',fname,' not readable by BertiniLab.'])
