function sstruct = mat2struct(poly_sys,M)
%MAT2STRUCT Convert matrix to structure
%
% S = poly_sys.mat2struct(M) inputs M, a sym/polysym/numeric array. Returns
% S, a structure. Each field is named after a variable and its value is an
% array of solutions for that variable. Vectors and matrices are placed in
% arrays of appropriate dimensions, with one column per vector and one page
% per matrix.
%
% If M is a collection of homogenized variables, they are dehomogenized.
%
% See also: struct2mat

validateattributes(M,{'polysym','sym','numeric'},{},'mat2struct','M',2)

M = poly_sys.dehomogenize(M);
vars = poly_sys.order_of_variables.put_in_arrays;

% Replace each variable by the solutions
sstruct = struct;
n = size(M,2);
for ii=1:numel(vars)
    name = vars{ii};
    
    value = polysym(zeros(numel(name),n)); 
    for jj=1:numel(name)
        idx = find(poly_sys.order_of_variables==name(jj));
        assert(~isempty(idx),'BertiniLab:match_solutions:notFound', ...
            'Input name not one of the output variables.')
        value(jj,:) = M(idx,:);
    end
    
    % Reshape into appropriate size array. Make sure that separate points
    % are not combined in a row.
    value = reshape(value,[size(name) n]);
    value = squeeze(value);
    if iscolumn(value) && n > 1
        value = value.';
    end
    
    field_name = vars{ii}.common_name;
    sstruct.(field_name) = value;
end