function interactive_file_name = make_interactive_choices(poly_sys,varargin)
%MAKE_INTERACTIVE_CHOICES Write interactive choices to file
%
% interactive_choices = poly_sys.make_interative_choices looks at the property
% interactive_choices. If it contains some strings, they are written to the
% file interactive_choices and '< interactive_choices' is return.
%
% interactive_choices = poly_sys.make_interactive_choices(fname) does the same
% and returns '< FNAME' if the file is created.
%
% The '<' before a file name is a redirect symbol that feeds the contents
% of the file to Bertini as if they were coming from the keyboard.
%
% See also: make_input_file, make_start_file

if isempty(poly_sys.interactive_choices)
    interactive_file_name = '';
    return
    
elseif nargin > 1
    fname = varargin{1};
    
else
    fname = 'interactive_choices';
end

% Convert any numeric inputs to string
idx = cellfun(@isnumeric,poly_sys.interactive_choices);
poly_sys.interactive_choices(idx) = cellfun(@num2str,poly_sys.interactive_choices(idx), ...
    'UniformOutput',false);

fname = poly_sys.fullname(fname);
fid = fopen(fname,'w');
fprintf(fid,'%s\n',poly_sys.interactive_choices{:});
fclose(fid);

interactive_file_name = ['< ',fname];
