function data = dehomogenize(poly_sys,data)
%DEHOMOGENIZE Convert homogeneous coordinates into affine coordinates
%
% data = poly_sys.dehomogenize(data) inputs DATA, a POLYSYM array. Returns
% the dehomogenized version of DATA.
%
% DEHOMOGENIZE reverses the homogenization of variables by Bertini. It
% finds which elements of DATA are declared in variable groups and assigns
% a homogenizing variable for each variable group. In homogeneous output
% from Bertini, these are the first components in each vector. Only
% variables declared in the property VARIABLE_GROUP are dehomogenized.
%
% See also: read_raw_data, read_witness_data

variable_order = poly_sys.order_of_variables;

% Data should be in columns.
if numel(variable_order) > 1 && isrow(data)
    data = data.';
end

% If there are no extra variables, no homogenization needed.
if size(data,1)==numel(variable_order)
    return
end

vars = poly_sys.variable_group;
if ~iscell(vars)
    vars = {vars};
end

nhom = numel(vars);
assert(size(data,1)==numel(variable_order)+nhom,'BertiniLab:dehomogenize:wrongSize', ...
    sprintf('Incorrect number of dehomogenizing variables. There should be %d.',nhom))

hom_vars = data(1:nhom,:);
data = data(nhom+1:end,:);
for ii=1:nhom
    [~,idx] = intersect(variable_order,vars{ii});
    data(idx,:) = data(idx,:)./repmat(hom_vars(ii,:),numel(idx),1);
end
