function bertiniVersion(filename)
%BERTINIVERSION Version information for a given instance of Bertini
%
% BertiniLab.bertiniVersion(filename) inputs FILENAME, either the full path
% name for Bertini or the root name if it is on the system path. Displays
% the version information in the command window.

[status,cmdout] = system([filename,' --version']);
assert(~status,'BertiniLab:bertiniVersion:notFound', ...
    sprintf('%s\n Check properties ''program_folder'' and ''program_name'' in BertiniLab.m',cmdout))

if isempty(getenv('BL_CALLED'))
    disp(cmdout)
    setenv('BL_CALLED','true')
end