function systemPath = addpath_system(fname)
%ADDPATH_SYSTEM Add folder to system path
%
% systemPath = BertiniLab.addpath_system(fname) inputs FNAME, a folder name
% (string) and adds the folder to the system path, if it is not already
% there.
%
% Remark: This is the only way I could think of to allow BertiniLab to call
% a program with spaces in its folder name on a PC.

if ispc
    systemPathSep = ';';
else
    systemPathSep = ':';
end

systemPath = getenv('PATH');

if isempty(strfind(systemPath,fname))
    systemPath = [fname,systemPathSep,systemPath];
    setenv('PATH',systemPath);
end
