C**********************************************************************
C
C     Copyright (C) 1991-1992  Roland W. Freund and Noel M. Nachtigal
C     All rights reserved.
C
C     This code is part of a copyrighted package.  For details, see the
C     file "cpyrit.doc" in the top-level directory.
C
C     *****************************************************************
C     ANY USE OF  THIS CODE CONSTITUTES ACCEPTANCE OF  THE TERMS OF THE
C                             COPYRIGHT NOTICE
C     *****************************************************************
C
C**********************************************************************
C
      PROGRAM TRANSP
C
C     This program transposes a CSC/CSR data file.
C
C     NOTE: This code uses an input format that, while valid on the Sun
C     and Cray compilers, might not be accepted  by other compilers. In
C     particular, the construct
C        WRITE (6,'(A30,$)') 'This is a test'
C     is used to prevent  the output processor from  moving to the next
C     line after writing the text.  If this construct  is not supported
C     by the compiler, remove the dollar sign ($).
C
C     Noel M. Nachtigal
C     October 16, 1992
C
C**********************************************************************
C
      EXTERNAL ZSPTRS, ZSPSRT, ZSPWAS
C
C     Compilation parameters.
C
      INTEGER NDIM
      PARAMETER (NDIM=6500)
      INTEGER NZMAX
      PARAMETER (NZMAX=300000)
C
C     Local variables.
C
      CHARACTER ANS*1, FMTIND*16, FMTPTR*16, FMTVAL*20, FMTRHS*20
      CHARACTER FNAME*32, KEY*8, RHSTYP*3, TITLE*72, TYPE*3
      INTEGER LINTOT, LINPTR, LININD, LINVAL, LINRHS, LINROW
      INTEGER I, IERR, J, K, NCOL, NELMTL, NNZ, NRHS, NROW
      INTEGER IA(NDIM+1), IB(NDIM+1), JA(NZMAX), JB(NZMAX)
      DOUBLE COMPLEX A(NZMAX), B(NZMAX)
C
C     Get the CSR/CSC data file from the user.
C
 10   WRITE (6,'(A30,$)') 'Enter CSR/CSC data file name: '
      READ (5,'(A32)') FNAME
C
C     Open the file.
C
      OPEN (10,FILE=FNAME,STATUS='old',ERR=40)
C
C     Read in the matrix header data.
C
      READ (10,'(A72,A8)') TITLE, KEY
      READ (10,'(5I14)') LINTOT, LINPTR, LININD, LINVAL, LINRHS
      READ (10,'(A3,11X,4I14)') TYPE, NROW, NCOL, NNZ, NELMTL
      READ (10,'(2A16,2A20)') FMTPTR, FMTIND, FMTVAL, FMTRHS
      IF (LINRHS.GT.0) READ (10,'(A3,11X,2I14)') RHSTYP, NRHS, LINROW
C
C     Output the matrix parameters.
C
      WRITE (6,'(A7,A73)') 'TITLE :',TITLE
      WRITE (6,'(A7,A11)') 'KEY   :',KEY
      WRITE (6,'(A7,A10)') 'TYPE  :',TYPE
      WRITE (6,'(A7,I10)') 'NDIM  :',NDIM
      WRITE (6,'(A7,I10)') 'NROW  :',NROW
      WRITE (6,'(A7,I10)') 'NCOL  :',NCOL
      WRITE (6,'(A7,I10)') 'NZMAX :',NZMAX
      WRITE (6,'(A7,I10)') 'NNZ   :',NNZ
      WRITE (6,'(A7,I10)') 'NRHS  :',NRHS
C
C     Check for errors.
C
      IERR = 0
      IF (NNZ.LE.0)         IERR = 1
      IF (NCOL.LE.0)        IERR = 1
      IF (NROW.LE.0)        IERR = 1
      IF (NNZ.GT.NZMAX)     IERR = 1
      IF (NCOL.GE.NDIM)     IERR = 1
      IF (NROW.GE.NDIM)     IERR = 1
      IF (TYPE(1:1).NE.'C') IERR = 1
      IF (TYPE(3:3).NE.'A') IERR = 1
      IF (IERR.NE.0) STOP
C
C     Read in the matrix data.
C
      READ (10,FMTPTR) (IB(I),I=1,NROW+1)
      READ (10,FMTIND) (JB(I),I=1,NNZ)
      READ (10,FMTVAL) (B(I),I=1,NNZ)
C
C     Close the file.
C
      CLOSE (10)
C
C     Transpose the matrix.
C
      CALL ZSPTRS (NROW,NCOL,B,IB,JB,A,IA,JA,0,0)
C
C     Order the indices in ascending order.
C
      DO 20 I = 1, NROW
         K = IA(I)
         J = IA(I+1) - K
         CALL ZSPSRT (J,A(K),JA(K))
 20   CONTINUE
C
C     Get the printout parameters.
C
      WRITE (6,'(A29,$)') 'How many digits to print:    '
      READ (5,*) I
C
C     Write out the matrix.
C
      WRITE (6,'(A29,$)') 'Enter output data file name: '
      READ (5,'(A32)') FNAME
      OPEN (10,FILE=FNAME)
      CALL ZSPWAS (NROW,NCOL,A,IA,JA,TITLE,KEY,TYPE,I,10,J)
C
C     Do it again?
C
 30   CLOSE(10)
      WRITE (6,'(A24,$)') 'Convert another (Y/N) ? '
      READ (5,'(A1)') ANS
      IF ((ANS.EQ.'Y').OR.(ANS.EQ.'y')) GO TO 10
C
C     Done.
C
      STOP
C
C     Handle any errors.
C
 40   WRITE (6,'(A30)') 'Data file could not be opened.'
      GO TO 30
C
      END
C
C**********************************************************************
