#line 1 "-"
#line 1 "gp.m4"
#include <stdio.h>
#include <stdlib.h>

#line 1 "gp.m4:cinclude.m4"

#line 9

























#define character_t  m4character_t
#define integer_t  m4integer_t
#define real_t  m4real_t
#define double_t  double
#define complex_t  m4complex_t
#define dcomplex_t  m4dcomplex_t


#define scalar_t double_t




#line 48

 /* This includes a file of m4 macros */
#line 5 "gp.m4"

typedef void (*statistics_reporter_t)(void* context, 
                                      char* name, 
                                      double_t* val);

struct gp_st {
  int  pivot_policy;
  double_t   pivot_threshold;
  double_t   drop_threshold;
  double_t   col_fill_ratio;
  double_t   fill_ratio;
  double_t   expand_ratio;
  int* col_perm;
  int  col_perm_length;
  int  col_perm_base;
  statistics_reporter_t reporter_func;
  void*                 reporter_ctxt;
};
typedef struct gp_st gp_t;

gp_create_c (gp_t **gp, int *info)
{
  if (((*gp) = (gp_t*) malloc( sizeof(gp_t) )) == NULL) {
    (*info) = 1;
    return;
  }

  (*gp)->pivot_policy    = 1;   /* 0=none, 1=partial, 2=threshold */
  (*gp)->pivot_threshold = 1.0; 
  (*gp)->drop_threshold  = 0.0; 
  (*gp)->col_fill_ratio  = -1.0; 
  (*gp)->fill_ratio      = 4.0; 
  (*gp)->expand_ratio    = 1.2;
  (*gp)->col_perm        = NULL;
  (*gp)->col_perm_length = 0;
  (*gp)->col_perm_base   = 0;
  (*gp)->reporter_func   = NULL;
 
  (*info) = 0;
}

gp_destroy_c (gp_t *gp) 
{
  if ( (gp)->col_perm ) free( (gp)->col_perm );
  free( (gp) );
}

gp_set_pivot_policy_c (gp_t      *gp, 
                             int pivot_policy)
{ (gp)->pivot_policy = pivot_policy; }

gp_get_pivot_policy_c (gp_t *gp, 
                             int *pivot_policy)
{ (*pivot_policy) = (gp)->pivot_policy; }

gp_set_pivot_threshold_c (gp_t     *gp, 
                                double_t pivot_threshold)
{ (gp)->pivot_threshold = pivot_threshold; }

gp_get_pivot_threshold_c (gp_t     *gp, 
                                double_t (*pivot_threshold))
{ (*pivot_threshold) = (gp)->pivot_threshold; }

gp_set_drop_threshold_c (gp_t     *gp, 
                                double_t drop_threshold)
{ (gp)->drop_threshold = drop_threshold; }

gp_get_drop_threshold_c (gp_t     *gp, 
                                double_t (*drop_threshold))
{ (*drop_threshold) = (gp)->drop_threshold; }

gp_set_col_fill_ratio_c (gp_t     *gp, 
                                double_t col_fill_ratio)
{ (gp)->col_fill_ratio = col_fill_ratio; }

gp_get_col_fill_ratio_c (gp_t     *gp, 
                                double_t (*col_fill_ratio))
{ (*col_fill_ratio) = (gp)->col_fill_ratio; }

gp_set_fill_ratio_c (gp_t *gp, 
                           double_t fill_ratio)
{ (gp)->fill_ratio = fill_ratio; }

gp_get_fill_ratio_c (gp_t     *gp, 
                           double_t *fill_ratio)
{ (*fill_ratio) = (gp)->fill_ratio; }

gp_set_expand_ratio_c (gp_t     *gp, 
                             double_t expand_ratio)
{ (gp)->expand_ratio = expand_ratio; }

gp_get_expand_ratio_c (gp_t      *gp, 
                             double_t  *expand_ratio)
{ (*expand_ratio) = (gp)->expand_ratio; }

gp_set_col_perm_c (gp_t       *gp, 
                         int* col_perm, 
                         int  length,
                         int  base,
                         int  *info)
{ 
  int j;

  if ( ((gp)->col_perm = 
          (int*) malloc( length * 
                               sizeof(int)) ) == NULL ) {
    (*info) = 1;
    return;
  }

  for (j=0; j<length; j++) 
    ((gp)->col_perm)[j] = col_perm[j]; 

  (gp)->col_perm_length = length; 
  (gp)->col_perm_base   = base; 
}

gp_get_col_perm_c (gp_t        *gp, 
                         int** col_perm, 
                         int   *length,
                         int   *base )
{ 
  *col_perm = (gp)->col_perm; 
  (*length) = (gp)->col_perm_length; 
  (*base)   = (gp)->col_perm_base; 
}

gp_set_statistics_reporter_c (gp_t     *gp, 
                                    statistics_reporter_t func,
                                    void*                 ctxt)
{ 
  (gp)->reporter_func = func; 
  (gp)->reporter_ctxt = ctxt; 
}

gp_get_statistics_reporter_c (gp_t      *gp, 
                                    statistics_reporter_t* func,
                                    void**                 ctxt)
{
  *func = (gp)->reporter_func;
  *ctxt = (gp)->reporter_ctxt;
}


