#include <stdio.h>
#include <stdlib.h>

include(`cinclude.m4') /* This includes a file of m4 macros */

typedef void (*statistics_reporter_t)(void* context, 
                                      character_t* name, 
                                      double_t* val);

struct gp_st {
  integer_t  pivot_policy;
  double_t   pivot_threshold;
  double_t   drop_threshold;
  double_t   col_fill_ratio;
  double_t   fill_ratio;
  double_t   expand_ratio;
  integer_t* col_perm;
  integer_t  col_perm_length;
  integer_t  col_perm_base;
  statistics_reporter_t reporter_func;
  void*                 reporter_ctxt;
};
typedef struct gp_st gp_t;

suffix(gp_create) (gp_t handle_out_arg(gp), integer_t scalar_out_arg(info))
{
  if ((handle_out(gp) = (gp_t*) malloc( sizeof(gp_t) )) == NULL) {
    scalar_out(info) = 1;
    return;
  }

  handle_out(gp)->pivot_policy    = 1;   /* 0=none, 1=partial, 2=threshold */
  handle_out(gp)->pivot_threshold = 1.0; 
  handle_out(gp)->drop_threshold  = 0.0; 
  handle_out(gp)->col_fill_ratio  = -1.0; 
  handle_out(gp)->fill_ratio      = 4.0; 
  handle_out(gp)->expand_ratio    = 1.2;
  handle_out(gp)->col_perm        = NULL;
  handle_out(gp)->col_perm_length = 0;
  handle_out(gp)->col_perm_base   = 0;
  handle_out(gp)->reporter_func   = NULL;
 
  scalar_out(info) = 0;
}

suffix(gp_destroy) (gp_t handle_in_arg(gp)) 
{
  if ( handle_in(gp)->col_perm ) free( handle_in(gp)->col_perm );
  free( handle_in(gp) );
}

suffix(gp_set_pivot_policy) (gp_t      handle_in_arg(gp), 
                             integer_t scalar_in_arg(pivot_policy))
{ handle_in(gp)->pivot_policy = scalar_in(pivot_policy); }

suffix(gp_get_pivot_policy) (gp_t handle_in_arg(gp), 
                             integer_t scalar_out_arg(pivot_policy))
{ scalar_out(pivot_policy) = handle_in(gp)->pivot_policy; }

suffix(gp_set_pivot_threshold) (gp_t     handle_in_arg(gp), 
                                double_t scalar_in_arg(pivot_threshold))
{ handle_in(gp)->pivot_threshold = scalar_in(pivot_threshold); }

suffix(gp_get_pivot_threshold) (gp_t     handle_in_arg(gp), 
                                double_t scalar_out(pivot_threshold))
{ scalar_out(pivot_threshold) = handle_in(gp)->pivot_threshold; }

suffix(gp_set_drop_threshold) (gp_t     handle_in_arg(gp), 
                                double_t scalar_in_arg(drop_threshold))
{ handle_in(gp)->drop_threshold = scalar_in(drop_threshold); }

suffix(gp_get_drop_threshold) (gp_t     handle_in_arg(gp), 
                                double_t scalar_out(drop_threshold))
{ scalar_out(drop_threshold) = handle_in(gp)->drop_threshold; }

suffix(gp_set_col_fill_ratio) (gp_t     handle_in_arg(gp), 
                                double_t scalar_in_arg(col_fill_ratio))
{ handle_in(gp)->col_fill_ratio = scalar_in(col_fill_ratio); }

suffix(gp_get_col_fill_ratio) (gp_t     handle_in_arg(gp), 
                                double_t scalar_out(col_fill_ratio))
{ scalar_out(col_fill_ratio) = handle_in(gp)->col_fill_ratio; }

suffix(gp_set_fill_ratio) (gp_t handle_in_arg(gp), 
                           double_t scalar_in_arg(fill_ratio))
{ handle_in(gp)->fill_ratio = scalar_in(fill_ratio); }

suffix(gp_get_fill_ratio) (gp_t     handle_in_arg(gp), 
                           double_t scalar_out_arg(fill_ratio))
{ scalar_out(fill_ratio) = handle_in(gp)->fill_ratio; }

suffix(gp_set_expand_ratio) (gp_t     handle_in_arg(gp), 
                             double_t scalar_in_arg(expand_ratio))
{ handle_in(gp)->expand_ratio = scalar_in(expand_ratio); }

suffix(gp_get_expand_ratio) (gp_t      handle_in_arg(gp), 
                             double_t  scalar_out_arg(expand_ratio))
{ scalar_out(expand_ratio) = handle_in(gp)->expand_ratio; }

suffix(gp_set_col_perm) (gp_t       handle_in_arg(gp), 
                         integer_t* col_perm, 
                         integer_t  scalar_in_arg(length),
                         integer_t  scalar_in_arg(base),
                         integer_t  scalar_out_arg(info))
{ 
  integer_t j;

  if ( (handle_in(gp)->col_perm = 
          (integer_t*) malloc( scalar_in(length) * 
                               sizeof(integer_t)) ) == NULL ) {
    scalar_out(info) = 1;
    return;
  }

  for (j=0; j<scalar_in(length); j++) 
    (handle_in(gp)->col_perm)[j] = col_perm[j]; 

  handle_in(gp)->col_perm_length = scalar_in(length); 
  handle_in(gp)->col_perm_base   = scalar_in(base); 
}

suffix(gp_get_col_perm) (gp_t        handle_in_arg(gp), 
                         integer_t** col_perm, 
                         integer_t   scalar_out_arg(length),
                         integer_t   scalar_out_arg(base) )
{ 
  *col_perm = handle_in(gp)->col_perm; 
  scalar_out(length) = handle_in(gp)->col_perm_length; 
  scalar_out(base)   = handle_in(gp)->col_perm_base; 
}

suffix(gp_set_statistics_reporter) (gp_t     handle_in_arg(gp), 
                                    statistics_reporter_t func,
                                    void*                 ctxt)
{ 
  handle_in(gp)->reporter_func = func; 
  handle_in(gp)->reporter_ctxt = ctxt; 
}

suffix(gp_get_statistics_reporter) (gp_t      handle_in_arg(gp), 
                                    statistics_reporter_t* func,
                                    void**                 ctxt)
{
  *func = handle_in(gp)->reporter_func;
  *ctxt = handle_in(gp)->reporter_ctxt;
}


