dnl cinclude.m4
dnl
dnl Sivan Toledo, 1997
dnl
dnl This file contains m4 macros to generate multiple C files from
dnl a single master file. The multiple versions are multiple precisions
dnl and both fortran and C style interfaces.

define(m4fortran_suffix,ifdef(`m4fortran_underscore_suffix',_))
define(m4c_suffix,_c)
define(m4suffix,ifelse(m4interfaces,C,m4c_suffix,m4fortran_suffix))

define(suffix,$1m4suffix)
define(fortran_suffix,$1m4fortran_suffix)

define(`m4prefix',m4precision)
ifelse(m4precision,S,`define(`m4prefix',s)',`define(`m4prefix',m4prefix)')
ifelse(m4precision,D,`define(`m4prefix',d)',`define(`m4prefix',m4prefix)')
ifelse(m4precision,C,`define(`m4prefix',c)',`define(`m4prefix',m4prefix)')
ifelse(m4precision,Z,`define(`m4prefix',z)',`define(`m4prefix',m4prefix)')

define(prec_prefix,m4prefix$1)

define(`scalar_out_arg',`*$1')
define(`scalar_out',`(*$1)')
define(`scalar_in_arg',ifelse(m4interfaces,C,`$1',`*$1'))
define(`scalar_in',ifelse(m4interfaces,C,`$1',`*$1'))

define(`handle_out_arg',`**$1')
define(`handle_out',`(*$1)')
define(`handle_in_arg',ifelse(m4interfaces,C,`*$1',`**$1'))
define(`handle_in',ifelse(m4interfaces,C,`($1)',`(*$1)'))

ifelse(T,T,`#define character_t ' m4character_t)
ifelse(T,T,`#define integer_t ' m4integer_t)
ifelse(T,T,`#define real_t ' m4real_t)
ifelse(T,T,`#define double_t ' m4double_t)
ifelse(T,T,`#define complex_t ' m4complex_t)
ifelse(T,T,`#define dcomplex_t ' m4dcomplex_t)

ifelse(m4prefix,s,`#define scalar_t real_t')
ifelse(m4prefix,d,`#define scalar_t double_t')
ifelse(m4prefix,c,`#define scalar_t complex_t')
ifelse(m4prefix,z,`#define scalar_t dcomplex_t')

dnl end of file


