        implicit real*4 (a-h,o-z)
        parameter  (nmax = 1826)
        parameter  (naux = 4*nmax*nmax)
        parameter  (nnn = 17)
        complex*8   a(nmax,nmax)
        complex*8   b(nmax,nmax)
        complex*8   c(nmax,nmax)
        real*4      aux(naux)
        integer     in, which
        integer     nn(nnn)
        character*8 names(4)
        data  nn     /  100,  120,  144,  172,  206,  247,  355,  426,
     *                  511,  613,  735,  882,
     *                 1000, 1058, 1269, 1522, 1826 /
        data  names  / 'CGEMMS  ', 'CGEMM   ', 'CGEMMW  ', 'CGEMUL3 ' /
c-----------------------------------------------------------------------
c Loop through various values of N
c-----------------------------------------------------------------------
        do 5001 in = 1,nnn
            n = nn(in)
            if ( n .le. 0 ) goto 5001
            if ( n .gt. nmax ) goto 5002
            write (*,'(a8)')    '-------'
            write (*,'(a4,i4)') 'N = ', n
            do 5000 which = 1,4
                call doit (which,n,a,b,c,aux,naux,t1)
c-----------------------------------------------------------------------
c Print out the timings
c-----------------------------------------------------------------------
c               flops = 2.0d0 * (dfloat(n)**3)
c               flops = 8.0d0 * (dfloat(n)**3)
                if ( t1 .ge. 0.0 )
     *              write (*,'(a8,f10.3)') names(which), 1.0d-6*t1
5000        continue
5001    continue
5002    end
        subroutine doit (which,n,a,b,c,aux,naux,t1)
        implicit real*4 (a-h,o-z)
        complex*8   a(n,n)
        complex*8   b(n,n)
        complex*8   c(n,n)
        real*4      aux(naux)
        real*8      second
        real*8      seed
        integer     i, j, which
c-----------------------------------------------------------------------
c Initialixze A, B, and C
c-----------------------------------------------------------------------
        seed=759150100.0
        call surand (seed,2*n*n,a)
        call surand (seed,2*n*n,b)
        call surand (seed,2*n*n,c)
        do j = 1,n
            do i = 1,n
                a(i,j)=a(i,j)-(.5,.5)
                b(i,j)=b(i,j)-(.5,.5)
                c(i,j)=c(i,j)-(.5,.5)
            enddo
        enddo
c-----------------------------------------------------------------------
c Compute C = A * B
c-----------------------------------------------------------------------
        t1 = -1.0
        if ( which.eq.1 ) then
c           t0 = second()
c           call cgemms (a,n,'N',b,n,'N',c,n,n,n,n,aux,naux)
c           t1 = second() - t0
        else if ( which.eq.2 ) then
            t0 = second()
            call cgemm  ('N','N',n,n,n,(1.0,0.0),a,n,b,n,
     *                   (0.0,0.0),c,n)
            t1 = second() - t0
        else if ( which.eq.3 ) then
            t0 = second()
            call cgemmw ('N','N',n,n,n,(1.0,0.0),a,n,b,n,
     *                   (0.0,0.0),c,n,aux,naux)
            t1 = second() - t0
        else if ( which.eq.4 ) then
            t0 = second()
            call cgemul3 (a,n,'N',b,n,'N',c,n,n,n,n,aux,naux)
            t1 = second() - t0
        endif
        return
        end
