/***********************************************************************
   This duplicates the clock function in System V.

   Last modified:  August 20, 1993.
 
   Calling sequence:

        real*8 second, t
        t = second()

   where 

        t will be in microseconds and is the user and system time
        combined.

***********************************************************************/
 
#include <sys/types.h>
#include <sys/times.h>
 
#ifndef CLK_TCK
#define CLK_TCK 60
#endif

#ifdef FortNames_Cap
double SECOND()
#elif FortNames_Under
double second_()
#else
double second()
#endif
{
    struct tms clock ;
    times(&clock) ;
    return (double)(clock.tms_utime + clock.tms_stime) * (1000000 / CLK_TCK) ; 
}

