      program test1
      parameter ( nmax = 301*301)
      parameter (alpha = 1.0, beta = 0.0)
      parameter (ntry = 20)
      real c1(nmax), c2(nmax), a(nmax), b(nmax)
c
c.....initialize arrays to zero
      do 10 i=1,nmax
        a(i) = 0.0
        b(i) = 0.0
        c1(i) = 0.0
        c2(i) = 0.0
 10   continue
c
c.....get parameter values m,n,k from standard input
      write(*,*)'Enter m,n,k (Enter 0,0,0 to quit)'
c
 20   continue
      read(*,*)m,n,k
      if (m.eq.0) goto 9999
      if (m*n.gt.nmax.or.m*k.gt.nmax.or.k*n.gt.nmax) then
        write(*,*)' **** Problem too large **** '
        STOP
      endif
c
c.....compute cost of call to irtc
      i1 = irtc()
      i2 = irtc()
      irtctim = i2 - i1
c
c.....define number of ops to compute C = A*B
      nops = 2*m*n*k - m*n
c
c.....print header
      write(*,100)'SGEMMW','SGEMM1','Ratio'
      write(*,100)'------','------','-----'
c
c.....Perform timing ntry times
      do 30 itry = 1,ntry
c
c.......time sgemmw
c       SGEMMW computes C = beta*c + alpha*A*B (Douglas interface)
        i1 = irtc()
        call sgemmw('No transpose','Transpose',m,n,k,alpha,a,m,
     &              b,k,beta,c1,m,0,0)
        i2 = irtc()
        itime = i2 - i1 - irtctim
        if (itry.eq.1.or.itime.lt.itsgemmw)  itsgemmw = itime
c
c.......time SGEMM1
c       SGEMM1 computes C = beta*c + alpha*A*B (1 cpu interface)
        i1 = irtc()
        call sgemm1('No transpose','Transpose',m,n,k,alpha,a,m,
     &              b,k,beta,c2,m)
        i2 = irtc()
        itime = i2 - i1 - irtctim
        if (itry.eq.1.or.itime.lt.itsgemm1)  itsgemm1 = itime
 30   continue
      c1 = c1 - c2
      diff = snrm2(nmax,c1,1)
      if (diff.gt.100.0*smach(3)) then
        print*,'Difference = diff'
        STOP
      endif
c
c.....time for SGEMMW
      time1 = 6.000E-09*float(itsgemmw)
      rate1 = float(nops)/(time1*1.0E06)
c
c.....time for SGEMM1
      time2 = 6.000E-09*float(itsgemm1)
      rate2 = float(nops)/(time2*1.0E06)
      ratio = time1/time2
c
c.....report results
      write(*,101)rate1,rate2,ratio
c
c.....repeat
      goto 20
c
 100  format(' ',a7,a7,1x,a7)
 101  format('  ',f6.2,1x,f6.2,1x,f8.4)
 9999 continue
      end

