/***********************************************************************
   This duplicates the clock function in System V.

   Last modified:  May 7, 1992
 
   Calling sequence:

        integer clock, t
        t = clock()

   where 

        t will be in microseconds and is the user and system time
        combined.

***********************************************************************/
 
#include <sys/types.h>
#include <sys/times.h>
 
#ifndef CLK_TCK
#define CLK_TCK 60
#endif

#ifdef FortNames_Cap
int CLOCK()
#elif FortNames_Under
double clock_()
#else
double clock()
#endif
{
    struct tms clock ;
    times(&clock) ;
    return (clock.tms_utime + clock.tms_stime) * (1000000 / CLK_TCK) ; 
}
