      program main
      parameter( Ncol1 = 9 )
c First column's identifiers
      character*1 col1(Ncol1)
      parameter( Ncpus = 5 )
c Number of cpu's computing
      character*2 cpus(Ncpus)
c File name
      character*80 fname
c Loop index
      integer i
c Loop index
      integer j
c Input line of text
      character*80 line
c Return index of last nonblank character
      integer lnblnk
      parameter( Nnames = 4 )
c Name of routines (minus first letter)
      character*6 names(Nnames)
      parameter( Nns = 5 )
c Values of N
      character*4 ns(Nns)
c Number of processors (Cray only)
      integer procs
c Routine's index
      integer rtn
c _gemm(n=1000) time for scaling other times
      real scal
c cpu time
      real time
      real ttimes(Nnames,Nns,Ncol1,Ncpus)
      parameter( Ntt = Ncol1*Nnames*Nns*Ncpus )
      data col1 / 'C', 'D', 'S', 'Z', 'N', 'c', 'd', 's', 'z' /
      data cpus / '01', '02', '04', '08', '16' /
      data names / 'GEMM  ', 'GEMMS ', 'GEMMW ', 'GEMUL3' /
      data ns / '1000', '1058', '1269', '1522', '1826' /
      data procs / 1 /
      data ttimes / Ntt * 0 /
100   continue
      write (*,*) 'File name:'
      read (*,'(a80)') fname
      open( 11, file=fname(1:lnblnk(fname)), status='old', err=100 )
2000  continue
200   continue
      read (11,'(a80)',end=500) line
c write (*,*) line(1:lnblnk(line))
      time = 0.0
      rtn = 0
c###############################################################
c Determine first column's value.  If it is in col1, then do 1
c of the following:
c   CDSZ:   Determine the routine name and record the time.
c   N:      Determine matrix size
c   cdsz:   Determine procs
c###############################################################
      do 2003  i = 1,Ncol1
          if(line(1:1).eq.col1(i)) then 
              if(i.le.4) then 
                  do 2005  rtn = 1,Nnames
                      if(line(2:7).eq.names(rtn)) then 
                          read(line(11:22),'(f12.7)') time
                          ttimes(rtn,nin,i,procs) = time
c write (*,*) 'rtn,name,time =',
c             col1(i),names(rtn), time,
c             rtn,nin,i,procs
                          goto 200
                      endif
2005              continue
              elseif(i.eq.5) then 
                  do 2007  j = 1,Nns
                      if(line(5:8).eq.ns(j)) then 
                          nin = j
c write (*,*) 'N =', ns(nin)
                          goto 200
                      endif
2007              continue
              elseif(i.ge.6.and.i.le.9) then 
                  do 2009  j = 1,Nns
                      if(line(6:7).eq.cpus(j)) then 
                          procs = j
c write (*,*) 'procs =', cpus(procs)
                          goto 200
                      endif
2009              continue
              endif
          endif
2003  continue
c###############################################################
c We have now finished reading the file.
c###############################################################
2001  goto 2000
500   continue
      close( 11 )
c###############################################################
c Now scale all of the numbers and print them in PicTeX format.
c###############################################################
c ttimes(Nnames,Nns,Ncol1,Ncpus)
      do 2011  procs = 1,Ncpus
          do 2013  i = 1,4
              if(ttimes(1,1,i,procs).ne.0.0) then 
                  scal = ttimes(1,1,i,procs)
                  write (*,'(/a1,a6,2x,a2,a4,2x,f12.2)') col1(i), names(
     *1), cpus(procs), ' cpu', scal
                  scal = 1.0 / scal
                  do 2015  k = 1,Nnames
                      write (*,'(a1,a6)') col1(i), names(k)
                      do 2017  j = 1,Nns
                          time = ttimes(k,j,i,procs) * scal
                          write (*,'(a4,3x,f8.2)') ns(j), time
2017                  continue
2015              continue
c       else
c           write (*,*) col1(i), names(rtn), ' Nothing'
              endif
2013      continue
2011  continue
      end
