PROGRAM sample6
! Section 3.6 of the manual "Computer Graphics PLOTTER"
! Sample 6: Temperature distribution between a high temperature cylinder and a
! low temperature plane.
! tt: temperature    xx: x-coordinate    yy: y-coordinate 
! aa: the height of the virtual line heat source.
! tt=(1/2)*LOG(xx**2+(yy+aa)**2)-(1/2)*LOG(xx**2+(yy-aa)**2)
! xx**2+yy*2-2*aa*yy+aa**2=4*aa*yy*ff   ff=1/(EXP(2*tt)-1)
! xx**2+(yy-bb)**2=cc**2   bb=aa*ff*(EXP(2*tt)+1)   cc=2*aa*ff*EXP(tt)
IMPLICIT NONE
REAL:: aa,bb,cc,ff,ex,ex2,tt,a1,b1,tt_max,col
INTEGER:: i,im
CALL pfnbegin('sample6')
CALL pfsorigin(105.,80.)
CALL pfscolor(0.,0.,0.)
aa=25;  a1=80;  b1=150
CALL prprctgl(-a1,0.,a1,b1)
tt_max=0.9;  im=50
DO i=1,im
  tt=(tt_max/im)*i
  ex=exp(tt);  ex2=ex**2;  ff=1/(ex2-1)
  bb=aa*ff*(ex2+1);  cc=2*aa*ff*ex
  col=(120./im)*(2*i-1)/2.
  IF(col < 100.) THEN
    CALL pfscolor(col,0.,0.)
  ELSE
    CALL pfscolor(100.,col-100.,0.)
    IF(i >= im) CALL pfscolor(100.,100.,100.)
  ENDIF
  CALL prpcrcl(0.,bb,cc)
ENDDO
CALL prprctgl(-120.,b1,120.,b1+180.)
CALL prprctgl(-120.-a1,-10.,-a1,b1+10)
CALL prprctgl(a1,-10.,a1+100,b1+10)
CALL pcsheight(4.);  CALL pcspstn(1,1);  CALL pfscolor(0.,0.,0.)
CALL pcwrite(0.,bb+6.,'\f1}High')
CALL pcwrite(0.,bb,'\f1}temperature')
CALL pcwrite(0.,bb-6.,'\f1}cylinder')
CALL pcspstn(1,3)
CALL pcwrite(0.,-1.,'\f1}Low temperature plane')
! Sample 6
CALL pfsorigin(0.,0.);  CALL pcspstn(1,0)
CALL pcwrite(105.,270.,'\f1}Sample 6')
END PROGRAM sample6
