PROGRAM sample5
! Section 3.5 of the manual "Computer Graphics PLOTTER"
! Sample 5: A graph with a logarithmic y-coordinate. 
! A graph of y=cosh(x)
IMPLICIT NONE
INTEGER,PARAMETER:: it=100
REAL:: dx(0:it),dy(0:it),xcomax,ycomax,xmin,ymin,xmax,ymax,alog_ymin, &
    alog_ymax,hh,xt0,yt0,xfact,yfact,a1,x1,y1,y0
INTEGER:: i,j
CHARACTER(5):: chr5
CALL pfnbegin('sample5')
xmin=-1;  xmax=10;  ymin=0.7;  ymax=3E4;  xcomax=100;  ycomax=90
! Determination of xfact, xt0, yfact and yt0
alog_ymin=LOG10(ymin);  alog_ymax=LOG10(ymax)
xfact=xcomax/(xmax-xmin)
yfact=ycomax/(alog_ymax-alog_ymin)
xt0=-xfact*xmin;  yt0=-yfact*alog_ymin
! Setting Plotter
CALL pfsorigin(60.,110.);  CALL plswidth(0.1)
CALL pldrctgl(0.,0.,xcomax,ycomax)
! x-axis
CALL pcsheight(4.);  CALL pcspstn(1,3)
DO i=-1,10
  x1=funxco(REAL(i));  a1=1
  IF(MOD(i,5) == 0) THEN
    a1=2;  WRITE(chr5,'(I2)') i
    CALL pcwrite(x1,-1.,'\f9}'//TRIM(ADJUSTL(chr5)))
  ENDIF
  CALL pldsgmnt(x1,0.,x1,a1)
  CALL pldsgmnt(x1,ycomax,x1,ycomax-a1)
ENDDO
CALL pcwrite(xcomax/2,-6.,'\f3}x')
! y-axis
CALL pcsheight(4.);  CALL pcspstn(2,1)
DO i=-1,5
  y0=10.**i
  DO j=2,9
    y1=funyco(j*y0)
    IF(y1 < 0) CYCLE;  IF(y1 > ycomax) EXIT
    CALL pldsgmnt(0.,y1,1.,y1)
    CALL pldsgmnt(xcomax,y1,xcomax-1,y1)
  ENDDO
  y1=funyco(y0)
  IF(y1 < 0) CYCLE;  IF(y1 > ycomax) EXIT
  CALL pldsgmnt(0.,y1,2.,y1)
  CALL pldsgmnt(xcomax,y1,xcomax-2,y1)
  WRITE(chr5,'(I1)') i
  CALL pcwrite(-1.,y1,'\f9}10\u}'//TRIM(ADJUSTL(chr5))//'\e}')
ENDDO
CALL pcspstn(1,0);  CALL pcsangle(1.5708)
CALL pcwrite(-13.,ycomax/2,'\f1}cosh\s4}\f3}x');  CALL pcsangle(0.)
! Curve:  y=cosh(x)
hh=(xmax-xmin)/it
DO i=0,it
  x1=i*hh+xmin
  dx(i)=funxco(x1);  dy(i)=funyco(COSH(x1))
ENDDO
CALL plstype(1);  CALL pldline(it+1,dx,dy)
! Sample 5
CALL pfsorigin(0.,0.);  CALL pcspstn(1,0)
CALL pcwrite(105.,270.,'\f1}Sample 5')
CALL pfnend
CONTAINS

FUNCTION funxco(x) RESULT(funx)
! xco=funxco(x)
! The variables used in common with the host procedure: xfact, xt0
REAL,INTENT(IN):: x
REAL:: funx
funx=xfact*x+xt0
END FUNCTION funxco

FUNCTION funyco(y) RESULT(funy)
! yco=funyco(y)
! The variables used in common with the host procedure: yfact, yt0
REAL,INTENT(IN):: y
REAL:: funy
funy=yfact*LOG10(y)+yt0
END FUNCTION funyco

END PROGRAM sample5
