PROGRAM sample4
! Section 3.4 of the manual "Computer Graphics PLOTTER"
! Sample 4: A graph with an anti-logarithmic ordinate. 
! Graphs of y=0.05*x**3+0.2*x**2+0.5 and y=SIN(x).
IMPLICIT NONE
INTEGER,PARAMETER:: it=50
REAL:: dx(0:it),dy(0:it),dy1(0:it),xcomax,ycomax,xmin,xmax,ymin,ymax, &
    hh,x1,xt0,yt0,xfact,yfact,a1,x,xf,y,yf
INTEGER:: i
CHARACTER(LEN=5):: chr5
CALL pfnbegin('sample4')
xmin=-5;  xmax=5;  ymin=-1.2;  ymax=1.5;  xcomax=100;  ycomax=90
! Determination of xfact, xt0, yfact and yt0
xfact=xcomax/(xmax-xmin);  xt0=-xfact*xmin
yfact=ycomax/(ymax-ymin);  yt0=-yfact*ymin
! Setting Plotter
CALL pfsorigin(60.,110.);  CALL plswidth(0.1)
CALL pldrctgl(0.,0.,xcomax,ycomax)
CALL pldsgmnt(0.,funyco(0.),xcomax,funyco(0.))
! x-axis
CALL pcsheight(4.);  CALL pcspstn(1,3)
DO i=-5,5
  x=i;  xf=funxco(x);  a1=1
  IF(MOD(i,5) == 0) THEN
    a1=2;  WRITE(chr5,'(I2)') i
    CALL pcwrite(xf,-1.,'\f9}'//TRIM(ADJUSTL(chr5)))
  ENDIF
  CALL pldsgmnt(xf,0.,xf,a1)
  CALL pldsgmnt(xf,ycomax,xf,ycomax-a1)
ENDDO
CALL pcwrite(xcomax/2,-8.,'\f3}x')
! y-axis
CALL pcspstn(2,1)
DO i=-12,15
  y=i*.1;  yf=funyco(y);  a1=1
  IF(MOD(i,5) == 0) THEN
    a1=2;  WRITE(chr5,'(F4.1)') y
    CALL pcwrite(-1.,yf,'\f9}'//TRIM(chr5))
  ENDIF
  CALL pldsgmnt(0.,yf,a1,yf)
  CALL pldsgmnt(xcomax,yf,xcomax-a1,yf)
ENDDO
CALL pcwrite(-16.,funyco(0.),'\f3}y')
! Functions y=0.05*x**3+0.2*x**2+0.5 and y=sin(x)
hh=(xmax-xmin)/it
DO i=0,it
  x=i*hh+xmin;  dx(i)=funxco(x)
  dy(i)=funyco((0.05*x+0.2)*x**2+0.5);  dy1(i)=funyco(SIN(x))
ENDDO
! Curve:  y=0.05*x**3+0.2*x**2+0.5
CALL plstype(1)
CALL plsframe(xcomax,ycomax);  CALL plsclip(1)
CALL pldline(it+1,dx,dy);  CALL plsclip(0)
CALL pcsheight(4.);  CALL pcspstn(0,1);  x1=35
CALL pcwrite(x1,ycomax+12, &
     '\f3}y\f1}\s4}=\s4}0.05\f3}x\u}\f1}3\e}+\s2}0.2\f3}x\f1}\u}2\e}+\s2}0.5')
CALL pldsgmnt(x1-20,ycomax+12,x1-2,ycomax+12)
! Curve:  y=sin(x)
CALL plstype(3);  CALL pldline(it+1,dx,dy1)
CALL pcwrite(x1,ycomax+5,'\f3}y\f1}\s4}=\s4}sin\s4}\f3}x')
CALL pldsgmnt(x1-20,ycomax+5,x1-2,ycomax+5)
! Sample 4
CALL pfsorigin(0.,0.);  CALL pcspstn(1,0)
CALL pcwrite(105.,270.,'\f1}Sample 4')
CALL pfnend
CONTAINS

FUNCTION funxco(x) RESULT(funx)
! xco=funxco(x)
! The variables used in common with the host procedure: xfact, xt0
REAL,INTENT(IN):: x
REAL:: funx
funx=xfact*x+xt0
END FUNCTION funxco

FUNCTION funyco(y) RESULT(funy)
! yco=funyco(y)
! The variables used in common with the host procedure: yfact, yt0
REAL,INTENT(IN):: y
REAL:: funy
funy=yfact*y+yt0
END FUNCTION funyco

END PROGRAM sample4
