PROGRAM sample2
! Section 3.2 of the manual "Computer Graphics PLOTTER"
! Sample 2: Scattering of a plane wave by a conducting wedge.
IMPLICIT NONE
REAL:: a1,ar2,ar3,ar4,phi0,r0,r1,r2,r3,r4,th0,th1,th3,y1,y2,co,si
REAL,PARAMETER:: pi=3.1415927
! A setting of Plotter
CALL pfnbegin('sample2')
CALL pfsorigin(95.,150.)
! Wedge
r0=50;  th0=-0.3*pi
CALL pcspstn(1,0);  CALL pcsheight(4.);  CALL plswidth(.2)
CALL pldsgmnt(0.,0.,r0,0.)
CALL pldsgmnt(0.,0.,r0*COS(th0),r0*SIN(th0))
CALL plswidth(.1)
r1=24.8
CALL pldcrclarc(0.,0.,r1,th0,0.)
CALL pldarcarrow(0.,0.,r1,th0,0.)
CALL pldarcarrow(0.,0.,r1,0.,th0)
CALL pcwrite(r1*COS(th0*.5)+8,r1*SIN(th0*.5)-3,'\f1}2\s2}\f10}p\s3}-\s3}a')
CALL pcwrite(45.,-25.,'\f1}CONDUCTOR')
! Incident wave
phi0=pi*.2;  ar2=40.;  ar3=15.;  ar4=ar2*0.6
co=COS(phi0);  si=SIN(phi0)
CALL pldsgmnt(ar2*co,ar2*si,0.,0.)
CALL pldarrow(ar2*co,ar2*si,ar4*co,ar4*si)
CALL pldcrclarc(0.,0.,ar3,0.,phi0)
CALL pldarcarrow(0.,0.,ar3,0.,phi0)
CALL pcsangle(phi0);  CALL pcspstn(0,0)
a1=17;  y1=1.5;  y2=7
CALL pcwrite(a1*co-y2*si,a1*si+y2*co,'\f1}INCIDENT')
CALL pcwrite(a1*co-y1*si,a1*si+y1*co,'\f1}WAVE')
CALL pcsangle(0.)
th3=phi0*.4;  CALL pcspstn(0,0)
CALL pcwrite(ar3*COS(th3)+1,ar3*SIN(th3),'\f10}j\l}\f1}0\e}')
! r
th1=pi*.8;  r2=35
CALL pldsgmnt(0.,0.,r2*COS(th1),r2*SIN(th1))
CALL pldarrow(0.,0.,r2*COS(th1),r2*SIN(th1))
r4=r2*.8
CALL pcwrite(r4*COS(th1),r4*SIN(th1)-6.,'\f3}r')
! phi
r3=r2*.5-8
CALL pldcrclarc(0.,0.,r3,0.,th1)
CALL pldarcarrow(0.,0.,r3,0.,th1)
CALL pcwrite(0.,r3+1.5,'\f10}j')
! z
r3=1.5
CALL pfscolor(100.,100.,100.)
CALL prpcrcl(0.,0.,r3)
CALL pfscolor(0.,0.,0.)
CALL pldcrcl(0.,0.,r3)
CALL prpcrcl(0.,0.,r3*.4)
CALL pcwrite(-3.,-5.,'\f3}z')
! Sample 2
CALL pfsorigin(0.,0.);  CALL pcspstn(1,0)
CALL pcwrite(105.,270.,'\f1}Sample 2')
CALL pfnend
END PROGRAM sample2
