PROGRAM sample1
! Section 3.1 of the manual "Computer Graphics PLOTTER"
! Sample 1: Execution of every subroutine of Plotter.
IMPLICIT NONE
REAL:: dxx(10),dyy(10),theta,th1,th2,aa,a1,a2,bb,x1,y1,x2,y2,x3,y3,x00
REAL,PARAMETER:: pi=3.141592
INTEGER:: i,nn,n1
CHARACTER(LEN=3):: chr3
CALL pfnbegin('sample1')

! Item 1: Subroutines pldhatching, prprctgl, prpcrcl, prpplygn and pfscolor.
x00=50
CALL pfsorigin(x00,242.)
CALL plswidth(.1)
aa=15;  nn=8;  theta=pi*2./nn
DO i=1,nn
  dxx(i)=aa*COS(i*theta);  dyy(i)=aa*SIN(i*theta)
ENDDO
CALL pldhatching(nn,dxx,dyy,.8,pi/4)
CALL pfscolor(100.,100.,100.)
CALL prprctgl(-2.,4.,9.,12.)
CALL prpcrcl(-7.,-3.,3.)
th1=pi*0.3;  x3=COS(th1);  y3=SIN(th1)
th2=pi*1.1;  x2=COS(th2);  y2=SIN(th2)
a1=-x3*(y2-y3)/(x2-x3)+y3;  a2=7;  a1=a2*a1
n1=5;  theta=pi/n1;  x1=5;  y1=-5
DO i=1,n1
  bb=theta*(2*i-1)+pi/2
  dxx(i*2-1)=a1*COS(bb)+x1;      dyy(i*2-1)=a1*SIN(bb)+y1
  dxx(i*2)=a2*COS(theta+bb)+x1;  dyy(i*2)=a2*SIN(theta+bb)+y1
ENDDO
CALL prpplygn(2*n1,dxx,dyy)
CALL pfscolor(0.,0.,0.)
CALL pcspstn(1,0);  CALL pcsheight(4.)
CALL pcwrite(0.,-25.,'\f1}Item 1')

! Item 2: Subroutine pldcross
CALL pfsorigin(x00-15,200.)
CALL pldcross(0.,0.,2.)
CALL pcwrite(0.,-10.,'\f1}Item 2')

! Item 3: Subroutines pldsgmnt and pldarrow
CALL pfsorigin(x00+15,200.)
CALL pldsgmnt(-8.,0.,8.,0.)
CALL pldarrow(-8.,0.,8.,0.)
CALL pcwrite(0.,-10.,'\f1}Item 3')

! Item 4: Subroutines pldcrclarc, pldarcarrow and prpcrcl
CALL pfsorigin(x00,160.)
CALL prpcrcl(0.,0.,2.)
CALL pldcrcl(0.,0.,4.)
CALL plstype(2);  CALL pldcrcl(0.,0.,6.)
CALL plstype(3);  CALL pldcrcl(0.,0.,8.)
CALL plstype(1)
CALL pldcrclarc(0.,0.,10.,1.,4.)
CALL pldarcarrow(0.,0.,10.,1.,4.)
CALL pcwrite(0.,-17.,'\f1}Item 4')

! Item 5: Subroutine pldrctgl
CALL pfsorigin(x00,120.)
CALL pldrctgl(-20.,0.,20.,5.)
CALL pcwrite(0.,-8.,'\f1}Item 5')

! Item 6: Subroutines pldsgmnt, plstype and plswidth
CALL pfsorigin(x00,90.)
CALL pcspstn(2,1);  CALL plswidth(.6)
x1=-15
CALL pcwrite(x1-4,0.,'\f1}1')
CALL pfscolor(100.,100.,0.)
CALL pldsgmnt(x1,0.,x1+35,0.)
CALL pfscolor(0.,0.,0.)
CALL plswidth(.1)
DO i=1,4
  WRITE(chr3,'(I3)') i
  y1=-6*i
  CALL pcwrite(x1-4,y1,'\f1}'//chr3)
  CALL plstype(i);  CALL pldsgmnt(x1,y1,x1+35,y1)
ENDDO
CALL pcspstn(1,0);  CALL pcwrite(0.,-32.,'\f1}Item 6')

! Item 7: Subroutines prprctgl, prpcrcl, prpplygn and pfscolor.
a2=5.
CALL pfsorigin(x00,40.)
DO i=1,3
 theta=2*i*pi/3.+pi/2.
 dxx(i)=a2*COS(theta)-18.;  dyy(i)=a2*SIN(theta)
ENDDO
CALL pfscolor(100.,0.,0.);  CALL prpplygn(3,dxx,dyy)
a1=a2/SQRT(2.)
CALL pfscolor(0.,100.,0.);  CALL prprctgl(-a1-6,-a1,a1-6,a1)
DO i=1,5
 theta=2*i*pi/5.+pi/10
 dxx(i)=a2*COS(theta)+6.;  dyy(i)=a2*SIN(theta)
ENDDO
CALL pfscolor(0.,0.,100.);  CALL prpplygn(5,dxx,dyy)
CALL pfscolor(0.,0.,0.);    CALL prpcrcl( 18.,0.,5.)
CALL pcwrite(0.,-12.,'\f1}Item 7')

! Item 8: Subroutine pcwrite;  code inputs
x00=145
CALL pfsorigin(x00,255.)
CALL pcspstn(1,0);  CALL pcwrite(3.,0.,'\f9}\264\270\245\256\261&
   &\272\271\266\243\263\265\242\262\274\327\307\310\f1}\134')
CALL pcspstn(1,1);  CALL pcwrite(0.,-5.,'\f1}Item 8')

! Item 9: Subroutine pcsangle, pcsheight and pcspstn
CALL pfsorigin(x00,220.)
CALL pcsangle(0.314);  CALL pcsheight(7.);  CALL pcspstn(0,0)
CALL pfscolor(0.,100.,0.)
CALL pcwrite(-18.,2.,'\f1}Graphics')
CALL pfscolor(0.,0.,0.)
CALL pcsangle(0.);  CALL pcsheight(4.);  CALL pcspstn(1,0)
CALL pcwrite(0.,-5.,'\f1}Item 9')

! Item 10: Subroutine pcwrite;   various fonts
CALL pfsorigin(x00,203.)
x1=-25
DO i=1,10
  y1=-8*i
  WRITE(chr3,'(I3)') i
  CALL pcspstn(2,1);   CALL pcwrite(x1-6,y1,'\f1}'//chr3)
  CALL pcspstn(0,1)
  CALL pcwrite(x1,y1,'\f'//TRIM(ADJUSTL(chr3))//'}ABCDEfghij123+-/)}>?!')
ENDDO
DO i=11,12
  y1=-8*i;  WRITE(chr3,'(I3)') i
  CALL pcspstn(2,1);  CALL pcwrite(x1-6,y1,'\f1}'//chr3)
  CALL pcspstn(0,1)
!  CALL pcwrite(x1,y1,'\f'//TRIM(ADJUSTL(chr3))//'}͊wZ')
ENDDO
CALL pcspstn(1,0)
CALL pcwrite(0.,-106.,'\f1}Item 10')

! Item 11: Subroutine pcwrite;   superscripts and subscripts
CALL pfsorigin(x00,75.)
CALL pcspstn(1,1);   CALL pcsheight(6.)
CALL pcwrite(-15.,0.,'\f3}ab')
CALL pcwrite(15.,0.,'\f3}cd\f1}ef')
CALL pcspstn(1,1);  y1=-15
CALL pcwrite(0.,y1,'\f3}b\f1}\u}2\l}2\e}\s3}\f3}b\f1}\l}3\e}\u}2\e}')
CALL pcwrite(0.,y1-15,'\f3}H\s2}\u}\f1}(2)\l}\f3}n\e}\f1}\s-3}(\f3}x\f1})\s4}&
    &\f3}e\u}\f1}sin\s3}\f3}x\f10}\s3}-\s3}\f3}x\e}\f1}\s3}tan\s4}\f3}y')
CALL pcsheight(4.)
CALL pcwrite(0.,y1-30,'\f1}Item 11')

! Sample 1
CALL pfsorigin(0.,0.);  CALL pcspstn(1,0)
CALL pcwrite(105.,270.,'\f1}Sample 1')
CALL pfnend
END PROGRAM sample1
