static char USMID[] = "@(#)xnotify.c	1.2 10/22/90 13:14:30 LLNL ";
#ifdef X11
#include <errno.h>
#include <math.h>
#include "externvars.h"
#include "xexterns.h"

extern int mode;
extern double new_blank_interval;   /* New clock interval during blanks */
extern int blankx;
extern double str_blank_clock;      /* Start of a blank interval (histogram) */

static int histFLAG = 0;
static int jumpby_FLAG = 0;
static int direction_FLAG = 0;
static int jumpto_choice = 0;
int jumpto_direction = 0;
int action_FLAG = 0;

/**********************************************************************
 * This file contains the routines which handle the notifica-
 * tions from the various buttons on the panel: 
 * go_notify_proc, load_notify_proc, connect_notify_proc, 
 * path_notify_proc, key_notfy_proc, quit_notify_proc,
 * step_notify_proc, stop_notify_proc,
 * recover_notify_proc,
 * and the routines which handle notifications from the sliders
 * on the panel:  e_speed_notify_proc and clock_interval_notify_proc,
 * and the support function
 * do_wait that causes a wait of the specified amount of time.
 * Also file_notify_proc, directory_notify_proc.
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,    */
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.     */
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

int first_time;

void scroll_update()
{
#ifdef DEBUG_SCROLLING
        fprintf(stderr, "scroll_update: ypos = (%d) (move_height-100) = (%d)\n",
                ypos, (move_height-100));
#endif
        if (ypos >= (move_height-100))
        {
                XtMoveWidget(inner_canvas,-CENTER,-(move_height-600));
                move_height += 80;
        }
        if (ypos > VIEWHEIGHT-200)
        {
                clearscreen(canvas_display,can_win);
                XtMoveWidget(inner_canvas,-CENTER,0);
                ypos = 30;
                move_height = 600;
        }
}

XtCallbackProc load_notify_proc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        int err;

        err = open_tracefile(file_table[ft_val]);
#ifdef DEBUG
        printf("load_notify_proc: tracefile to load is %s\n", file_table[ft_val]);
#endif
        if (err != 0)
        {
                display_message("Select another tracefile\n");
        }
        first_time = 1;
        return;
}

XtCallbackProc go_notify_proc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        char str[40];
        double ending_clock;
        int y;
    
#ifdef CRAYTRACE
        jumpingFLAG = 0;        /* set to log new events */
#endif CRAYTRACE
        go = 1;
        if (done)
        {
                XBell(canvas_display,0);
                display_message("Have processed all events - GO\n");
        } else if (!filepresent)
        {
                XBell(canvas_display,0);
                display_message("ERROR: No tracefile specified\n");
        } else
        { 
                display_message("\nTo stop, hold down left mouse button in panel\n");
                /* Looping around screen updates */
                while (!button_hit() && !done && go)
                {      
                        scroll_update();
                        if  ((real_clock-clock_interval) > program_clock)
                        {       
                                if (blank_intervals  == 0)
                                {                       
                                        draw_timestamp(1,ypos);
                                        XDrawLine(canvas_display, can_win,
                                                canvas_gc, 0, ypos, PCX+CENTER,
                                                ypos);
                                        ypos += NODEHEIGHT;
                                        blankx = 200;
                                        new_blank_interval = clock_interval;
                                        /* For histogram */
                                        str_blank_clock = program_clock;
                                        XDrawLine(canvas_display,can_win,
                                                canvas_gc,blankx+CENTER,
                                                ypos-NODEHEIGHT+1, blankx+CENTER,
                                                ypos);
                                        blank_intervals++;
                                        display_time_warp(program_clock -
                                                last_real_clock);
                                        last_real_clock = program_clock;
                                        program_clock += clock_interval;
                                } else
                                {
                                        ending_clock=initial_clock + (clock_interval*floor((real_clock-initial_clock)/clock_interval));
                                        draw_blank_intervals(ending_clock);
                                }
                        } else if (program_clock > real_clock)
                        {               
                                process_event();
                                display_time_warp(real_clock - last_real_clock);
                                significant_input(0);
                        } else
                        {
                                /* Finish off blank?  */
                                if (blank_intervals != 0)
                                {
                                        /* Finish off timestamp */
                                        draw_timestamp(100,ypos-NODEHEIGHT);
                                        /* Finish off histogram */
                                        plot_histogram(1);
                                        blank_intervals = 0;
                                }                   
                                draw_timestamp(1,ypos);                         
                                XDrawLine(canvas_display, can_win,
                                        canvas_gc, 0, ypos, PCX+CENTER, ypos);
                                plot_histogram(2);
                                blank_intervals = 0;
                                program_clock += clock_interval;                
                                process_event();
                                display_time_warp(real_clock - last_real_clock);
                                significant_input(0);
                        }
                } /* End while */
        }  /* End else */                                               
        /* fix -1 entries from being printed while jumping*/
        sprintf(str,"Events Processed: %d",
                ((curr_events-1)<0)?0:(curr_events-1));
        XClearArea(control_display,control_win,424,75,150,13,True);
        XDrawString(control_display,control_win,canvas_gc,424,85,
                str,strlen(str));
        sprintf(str,"Number of  Tasks: %d",curr_tasks);
        XClearArea(control_display,control_win,424,90,150,13,True);
        XDrawString(control_display,control_win,canvas_gc,424,100,
                str,strlen(str));
        return;
}

draw_blank_intervals(ending_clock)
double ending_clock;    
{
/*************************************
 * Recursive fun... 
 *************************************/
        int y, endy;

        if (button_hit())
        {
                blank_intervals = 0;
                draw_timestamp(100,ypos-NODEHEIGHT);
        } else
        {
                if (program_clock < ending_clock)
                {
                        draw_timestamp(100,ypos-NODEHEIGHT);
                        blankx = blankx + ((log10(new_blank_interval) -
                                log10(clock_interval)) + 1);
                        y = ypos - NODEHEIGHT+1;
                        endy = ypos;
                        if (blankx < PCX)
                        {
                                XDrawLine(canvas_display,can_win,canvas_gc,
                                        blankx+CENTER, y, blankx+CENTER, endy);
                        } else
                        {
                                blankx = 200;
                        }
                        blank_intervals++;
                        if (blank_intervals % 100 == 0)
                        {
                                new_blank_interval *= 10;
                                display_time_warp(new_blank_interval);
                        }
                        last_real_clock = program_clock;
                        program_clock += new_blank_interval;
                        draw_blank_intervals(ending_clock);
                }
                if (program_clock > ending_clock)
                {
                        program_clock = ending_clock;
                        display_time_warp(program_clock - last_real_clock);     
                        last_real_clock = ending_clock;
                        draw_timestamp(100,ypos-NODEHEIGHT);
                }
        }
}

XtCallbackProc step_notify_proc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        char str[40];

#ifdef CRAYTRACE
                jumpingFLAG = 0;        /* set to log new events */
#endif CRAYTRACE
        if (done)
        {
                XBell(canvas_display,0);
                display_message("Have processed all events - STEP\n");
        } else if (!filepresent)
        {
                XBell(canvas_display,0);
                display_message("ERROR: No tracefile specified\n");
        } else  /* Events to be processed */    
        {
                scroll_update();
                /* Interval within a break.. */
                if  ((real_clock-clock_interval) > program_clock)
                {
                        /* ..update prgm_clock    */
                        if (blank_intervals  == 0)
                        {
                                draw_timestamp(1,ypos);
                                XDrawLine(canvas_display,can_win,
                                        canvas_gc, 0, ypos, PCX+CENTER, ypos);
                                ypos += NODEHEIGHT;
                                blankx = 200;
                                new_blank_interval = clock_interval;
                                XDrawLine(canvas_display,can_win,
                                        canvas_gc, blankx+CENTER,
                                        ypos-NODEHEIGHT+1,
                                        blankx+CENTER, ypos);
                        } else
                        {
                                draw_timestamp(100,ypos-NODEHEIGHT);
                                ++blankx;
                                if (blankx < PCX)
                                {
                                        XDrawLine(canvas_display,can_win,
                                           canvas_gc, blankx+CENTER,
                                           ypos-NODEHEIGHT+1,
                                           blankx+CENTER, ypos);
                                } else
                                {
                                        blankx = 200;
                                }
                        }       
                        plot_histogram(2);
                        /* For histogram */
                        str_blank_clock = program_clock;
                        blank_intervals++;
                        display_time_warp(program_clock-last_real_clock);
                        last_real_clock = program_clock;
                        program_clock += clock_interval;
                } else if (program_clock > real_clock)
                {
                        process_event();
                        display_time_warp(real_clock - last_real_clock);
                        significant_input(1);
                } else
                {                                                      
                        /* Finish off blank */
                        if (blank_intervals != 0)
                        {
                                /* Finish off timestamp */
                                draw_timestamp(100,ypos-NODEHEIGHT);
                                /* Finish off histogram */
                                plot_histogram(1);
                                blank_intervals = 0;
                        }
                        draw_timestamp(1,ypos);                         
                        XDrawLine(canvas_display, can_win,
                                canvas_gc, 0, ypos, PCX+CENTER, ypos);
                        plot_histogram(2);
                        program_clock += clock_interval;                
                        process_event();
                        display_time_warp(real_clock - last_real_clock);
                        significant_input(1);
                } /* end new else */
        } /* end process else */
}

int button_hit()
/* This function returns zero if the LEFT mouse button has not been hit
 * and non-zero if it has. */
{
        XEvent report;
        long event_mask;

        event_mask = ButtonPressMask;
        if( XCheckMaskEvent(canvas_display,event_mask,&report) != 0 )

       {
                if( report.type == ButtonPress || report.type == LeaveNotify )
                {
			go = 0;
                        return(1);

                }
        }
        return(0);
}



void display_notify_proc(widget, closure, listp)
Widget widget; caddr_t closure; XtListReturnStruct *listp;
{
/*************************************************
 * sets the value of the global variable display_
 * type.  A value of 0 indicates that the list of 
 * locks should be displayed, 1 for events, and 
 * 2 for barriers.
 ************************************************/
        Arg args[1];

        XtPopdown(address_shell);
        XtSetArg(args[0],XtNlabel,listp->string);
        XtSetValues(address_choice,args,1);

#ifdef X11R3
        display_type = listp->index;
#else
        display_type = listp->list_index;
#endif
        return;
}


void machine_notify_proc(widget, closure, listp)
Widget widget; caddr_t closure; XtListReturnStruct *listp;
{
        XtPopdown(machine_shell);
        XtSetArg(args[0],XtNlabel,listp->string);
        XtSetValues(machine_choice,args,1);

#ifdef X11R3
        switch(listp->index)
#else
        switch(listp->list_index)
#endif
        {
                case 0:         /* Cray XMP */
                        clock_cycle = (8.5 * pow(10.0,-9.0));           
                break;
#ifdef CTSSTRACE
                case 1:         /* Alliant */
                        clock_cycle = (65 * pow(10.0,-9.0));            
                break;
#endif
#ifdef CRAYTRACE
                case 1:         /* Cray-2 */
                        clock_cycle = (4.1 * pow(10.0,-9.0));           
                break;
                case 2:         /* Cray Y-MP */
                        clock_cycle = (6.0 * pow(10.0,-9.0));           
                break;
#endif
        }
        return;
}

void interval_notify_proc(widget, closure, listp)
Widget widget; caddr_t closure; XtListReturnStruct *listp;
{
        XtPopdown(interval_shell);
        XtSetArg(args[0],XtNlabel,listp->string);
        XtSetValues(interval_choice,args,1);

#ifdef X11R3
        clock_interval = pow(10.0,(double)listp->index);
#else
        clock_interval = pow(10.0,(double)listp->list_index);
#endif
        /* Adjust the program clock */
        program_clock=initial_clock +
        (clock_interval*floor((real_clock-initial_clock)/clock_interval));
}


void idle_notify_proc(widget, closure, listp)
Widget widget; caddr_t closure; XtListReturnStruct *listp;
{
        XtPopdown(idle_shell);
        XtSetArg(args[0],XtNlabel,listp->string);
        XtSetValues(idle_choice,args,1);
#ifdef X11R3
        switch (listp->index)
#else
        switch (listp->list_index)
#endif
        {
                case 0:
                        idle_interval = 100000;
                        break;
                case 1:
                        idle_interval = 500000;
                        break;
                case 2:
                        idle_interval = 1000000;
                        break;
                case 3:
                        idle_interval = 5000000;
                        break;
                case 4:
                        idle_interval = 10000000;
                        break;
                case 5:
                        idle_interval = 50000000;
                        break;
                case 6:
                        idle_interval = 100000000;
                        break;
                case 7:
                        idle_interval = 500000000;
                        break;
        }
}



void connect_notify_proc()
{
        display_message("Will handle socket input\n");
        key_enable = 0;
}


XtCallbackProc hist_notify_proc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
/*******************************************
 * Will cause histogram to be displayed if 
 * it is not displayed already - else will
 * remove the histogram display.
 ******************************************/
        XSetWindowAttributes attr;

        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+83);
        XtSetArg(args[1],XtNy,frameAttributes.y+395);
        XtSetValues(hist_shell,args,2);
        if( histFLAG == 0 )
        {
                XtPopup(hist_shell,XtGrabNone);
                histFLAG = 2;
        } else if( histFLAG == 1 )
        {
                XtPopup(hist_shell,XtGrabNone);
                histFLAG = 2;
        } else
        {
                XtPopdown(hist_shell);
                histFLAG = 1;
        }
        return;
}



void file_notify_proc(widget, closure, listp)
Widget widget; caddr_t closure; XtListReturnStruct *listp;
{
        Arg args[1];
        char str[50];


#ifdef X11R3
        ft_val = listp->index;
#else
        ft_val = listp->list_index;
#endif

        strncpy(str,file_table[ft_val],43);
        strncat(str,"                                           ",(43-strlen(str)));
        XtSetArg(args[0],XtNlabel,str);
        XtSetValues(file_choice,args,1);

        XtPopdown(file_shell);
}

void directory_notify_proc(widget, closure, listp)
Widget widget; caddr_t closure; XtListReturnStruct *listp;
{
        char str[200];

#ifdef X11R3
        dt_index = listp->index;
#else
        dt_index = listp->list_index;
#endif

        if( dt_index == 0 )
        {
                strcpy(str,".");
        } else if( dt_index == 1 )
        {
                strcpy(str,"..");
        } else
        {
                strncpy(str,directory_table[dt_index],200);
        }
        if (chdir(str) == -1)
        {
                sprintf(str,"WARNING: chdir failed, errno = %d\n",
                        errno);
                display_message(str);
        } else
        {
                dt_index = 0;
                load_directory_table();
        }

        XtPopdown(dir_shell);
        XtSetSensitive(directory_choice,True);
}

static int newsFLAG = 0;
XtActionProc news_notify_proc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        if( newsFLAG == 0 )
        {
                XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
                XtSetArg(args[0],XtNx,frameAttributes.x+100);
                XtSetArg(args[1],XtNy,frameAttributes.y+300);
                XtSetValues(hist_shell,args,2);

                XtPopup(news_shell,XtGrabNone);
                newsFLAG = 1;
        } else
        {
                XtPopdown(news_shell);
                newsFLAG = 0;
        }
}

/* POPUP PANEL STUFF */
void execute_notify_proc()
{
        char str[60];
        int choice;
        Arg args[2];
        char *textptr;
        int text;
        int i;
        int temp_curr_process = 0;
#ifdef CRAYTRACE
        int nb;
#include "log_entry.h"
        char junkbuf[NB_THEADER];
#endif

        direction = jumpto_direction;
        choice = jumpto_choice;
        textptr = (char *)XtDialogGetValueString(jumpto_value);
        if( direction_FLAG == 1 )
        {
                XtPopdown(jump_direction_shell); 
                direction_FLAG = 0;
        }
        if( jumpby_FLAG == 1 )
        {
                XtPopdown(jumpby_shell); 
                jumpby_FLAG = 0;
        }
        if( action_FLAG == 1 )
        {
                XtPopdown(action_shell);
                action_FLAG = 0;
        }
        sscanf(textptr, "%d", &text);
        XtPopdown(jump_shell);

        sprintf(str,"Jumping from event # %d to %s %d.\n",
                curr_events, jumpby_table[choice], text);
        display_message(str);

        if (done)
        {
                XBell(canvas_display,0);
                display_message("Have processed all events - JUMP\n");
        } else if (!filepresent)
        {
                XBell(canvas_display,0);
                display_message("ERROR: No tracefile specified\n");
        } else
        {       
#ifdef DEBUG
                printf("execute_notify_procs processing %d  %d\n", curr_action,
                        curr_id);
#endif
        /* It is given that the tracefile line to be process is already
         * looked up.   Therefore process the line just as it is.  There
         * may be a problem eventually since the if a jump is done 
         * initially the current action and id are initialized to zero.
         * This should make a difference since 0 tid's are typically 
         * ignored and the 0th element of the process[tid(0)] are 
         * ignored. */
#ifdef CRAYTRACE
     jumpingFLAG = 0;   /* set to log new events */
#endif CRAYTRACE
     switch(direction) /* forward or back */
     {
      case 0:   /* seek forward */
        switch (choice)
        {
        case 2:  /* Find by Action Number */
                do
                {
                        update_nonpost_events();
                        update_task();
                        if (curr_action == RECOVER )
                        {
                                screen[pixel_to_array(tasks[curr_id].x)].taskid
                                                = 0;
                                tasks[curr_id].x = 0;       
                        }
                        tasks[curr_id].post_event = -1;
                        tasks[curr_id].aux_item = 0;
                        if ((curr_events%50) == 0)
                        {
                                sprintf(str,"Events Processed: %d",
                                ((curr_events-1)<0)?0:(curr_events-1));
                                XClearArea(control_display,control_win,
                                        424, 75, 150, 13, True);
                                XDrawString(control_display,control_win,
                                        control_gc,424,85,str,strlen(str));
                                XFlush(control_display);
                        }
                        data_input(0);
                        /* This is a special case.  When the user jumps to start
                        * of tasks the LIGHT (32766) is not recognized.  This
                        * will make it recognized. */
                        if( curr_action == LIGHT && text == START )
                                break;
                } while(!done && (curr_action != text));
                break;
        case 1:  /*  Find by Task Number */
                jump_to_task(text);
                break;
        case 0:  /*  Find by Event Count */
                jump_to_event(text);
                break;
        }
        break;
      case 1: /* seek backward */
#ifdef CRAYTRACE
        jumpingFLAG = 1;    /* set for data_seek to log new jumps */
#endif CRAYTRACE
        data_seek(choice,text);
        if( go < 0 )
        {
                go = 0;
        }
        last_real_clock= initial_clock;
        initflag = 0;
        filter_display = 0;
        XtSetArg(args[0],XtNlabel,filter_table[filter_display]);
        XtSetValues(filter_button,args,1);
        data_input();
        break;
      case 2:   /* rewind log */
        rewind_file();
        break;
     }
        
        clearscreen(canvas_display,can_win);
        clearscreen(hidden_display, hidden_win);
        XtMoveWidget(inner_canvas,-CENTER,0);

        ypos = 0;
        
        temp_curr_process = curr_process;
        for (i = 0; i < MAXPROCS; i++)
        {
                curr_process = i;
                draw_process();
        }
        curr_process= temp_curr_process;

        program_clock=initial_clock + 
        (clock_interval*floor((real_clock-initial_clock)/clock_interval));
        
        sprintf(str,"Active Processes: %d",curr_procs);         
        XClearArea(control_display,control_win,
                424, 60, 150, 13, True);
        XDrawString(control_display,control_win,
                control_gc,424,70,str,strlen(str));
        sprintf(str,"Number of  Tasks: %d",curr_tasks);
        XClearArea(control_display,control_win,
                424, 90, 150, 13, True);
        XDrawString(control_display,control_win,
                control_gc,424,100,str,strlen(str));
        sprintf(str,"Events Processed: %d",
                ((curr_events-1)<0)?0:(curr_events-1));
        XClearArea(control_display,control_win,
                424, 75, 150, 13, True);
        XDrawString(control_display,control_win,
                control_gc,424,85,str,strlen(str));
        }


}

static jumpFLAG = 0;
static directionFLAG = 0;
XtCallbackProc events_notify_proc(widget,client_data,call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        if( widget == jumpby_choice)
        {
                XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
                XtSetArg(args[0],XtNx,frameAttributes.x+415);
                XtSetArg(args[1],XtNy,frameAttributes.y+153);
                XtSetValues(jumpby_shell,args,2);

                XtPopup(jumpby_shell,XtGrabNone);
                jumpby_FLAG = 1;
        }

        if(widget == jumpDirection_choice)
        {
                XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
                XtSetArg(args[0],XtNx,frameAttributes.x+402);
                XtSetArg(args[1],XtNy,frameAttributes.y+173);
                XtSetValues(jump_direction_shell,args,2);

                XtPopup(jump_direction_shell,XtGrabNone);
                direction_FLAG = 1;
        }
        return;
}


void set_direction_selection(widget,value,listp)
Widget widget; caddr_t value; XtListReturnStruct *listp;
{
#ifdef X11R3
        jumpto_direction = listp->index;
#else
        jumpto_direction = listp->list_index;
#endif
        XtSetArg(args[0],XtNlabel,listp->string);
        XtSetValues(jumpDirection_choice,args,1);
        XtPopdown(jump_direction_shell);
        direction_FLAG = 0;
}


void set_jump_selection(widget,value,listp)
Widget widget; caddr_t value; XtListReturnStruct *listp;
{
#ifdef X11R3
        jumpto_choice = listp->index;
#else
        jumpto_choice = listp->list_index;
#endif
        XtSetArg(args[0],XtNlabel,listp->string);
        XtSetValues(jumpby_choice,args,1);
        XtPopdown(jumpby_shell);
        jumpby_FLAG = 0;
        if( jumpto_choice == 2 && action_FLAG == 0)
        {
                XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
                XtSetArg(args[0],XtNx,frameAttributes.x+415);
                XtSetArg(args[1],XtNy,frameAttributes.y+195);
                XtSetValues(action_shell,args,2);

                XtPopup(action_shell, XtGrabNone);
                action_FLAG = 1;
        }
}


XtCallbackProc cancel_notify_proc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        if( jumpby_FLAG == 1 )
        {
                XtPopdown(jumpby_shell);
                jumpby_FLAG = 0;
        }
        XtPopdown(jump_shell);
        if( direction_FLAG == 1 )
        {
                XtPopdown(jump_direction_shell); 
                direction_FLAG = 0;
        }
        return;
}

void action_notify_proc(widget,value,listp)
Widget widget; caddr_t value; XtListReturnStruct *listp;
{
        Arg args[2];
        char str[40];
        extern int action_FLAG;
        extern Arg jumptoValueArgs[];
        extern Arg jumpbyChoiceArgs[];

        XtPopdown(action_shell);
        XtDestroyWidget(jumpto_value);

#ifdef X11R3
        sprintf(str,"%d",action_number[listp->index]);
#else
        sprintf(str,"%d",action_number[listp->list_index]);
#endif 
        XtSetArg(jumptoValueArgs[0],XtNlabel,"Hello world");
        XtSetArg(jumptoValueArgs[6],XtNvalue,str);
        jumpto_value = XtCreateManagedWidget("jumpWindow", dialogWidgetClass,
                                jump_pop, jumptoValueArgs, 9);

        XtDestroyWidget(jumpby_choice);
        XtSetArg(jumpbyChoiceArgs[2],XtNlabel,jumpby_table[jumpto_choice]);
        jumpby_choice = XtCreateManagedWidget("command", commandWidgetClass,
                                jump_pop, jumpbyChoiceArgs, 6);
        XtAddCallback(jumpby_choice,XtNcallback,events_notify_proc);

        action_FLAG = 0;
}

XtCallbackProc filter_notify_proc(widget,value,listp)
Widget widget; caddr_t value; XtListReturnStruct *listp;
{
        Arg args[1];
        extern Widget filter_shell;

#ifdef X11R3
        filter_display = listp->index;
#else
        filter_display = listp->list_index;
#endif
        XtSetArg(args[0],XtNlabel,listp->string);
        XtSetValues(filter_button,args,1);
        XtPopdown(filter_shell);
}


update_nonpost_events()
{
/*********************************************************
 * check_nonpost_events filters out all of the events
 * which do not correspond to specific tasks. Returns 1
 * if the event was a nontask event, else returns 0.
 *********************************************************/

        switch (curr_action)
        {
        case ACQUIRE :
                procs[curr_process].state = 4;   /* now acquired but unbound */
        break;
        case IDLE :
                procs[curr_process].state = 0;
        break;
        case SUSPEND :
                procs[curr_process].state = 1;
        break;
        case REACQUIRE :
        case REQSUS:
                procs[curr_process].state = 2;
        break;
        case LOST :
                display_message("Logged events lost - view is invalid\n");
        break;
        default :
                /* Check for and ignore killer actions */
                if (curr_id == 0)
                        return(1);
                else
                        return(0);
        }
        return(1);
}         

jump_to_task(text)
int text;
{
        char str[20];

        do {                /* force one iteration. */
                update_nonpost_events();
                update_task();
                if (curr_action == RECOVER )
                {
                        screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;
                        tasks[curr_id].x = 0;
                }
                tasks[curr_id].post_event = -1;
                tasks[curr_id].aux_item = 0;
                if ((curr_events%50) == 0)
                {
                        /* fix -1 entries from being printed while
                        * jumping, */
                        sprintf(str,"Events Processed: %d",
                        ((curr_events-1)<0)?0:(curr_events-1));
                        XClearArea(control_display,control_win,
                                424, 75, 150, 13, True);
                        XDrawString(control_display,control_win,
                                control_gc,424,85,str,strlen(str));
                        XFlush(control_display);
                }
                data_input(0);          /* read the next data line. */
        } while(!done && (curr_id != text));
}

jump_to_event(text)
int text;
{
        char str[30];

        do 
        {
                update_nonpost_events();
                update_task();
                if (curr_action == RECOVER )
                {
                        screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;
                        tasks[curr_id].x = 0;       
                }
                tasks[curr_id].post_event = -1;

                tasks[curr_id].aux_item = 0;
                if ((curr_events%50) == 0)
                {
                        sprintf(str,"Events Processed: %d",
                                ((curr_events-1)<0)?0:(curr_events-1));
                        XClearArea(control_display,control_win,
                                424, 75, 150, 13, True);
                        XDrawString(control_display,control_win,
                                control_gc,424,85,str,strlen(str));
                        XFlush(control_display);
                }
                data_input(0);
        } while(!done && (curr_events < text));
}

#if CRAY2 || CRAY
#define L_SET  0 /* set the seek pointer */
#endif 
int rewind_file()
{
#ifdef CRAYTRACE
        int nb;
#include "log_entry.h"
        char junkbuf[NB_THEADER];
#endif
        double save_init_clock;
        lseek(fp,0,L_SET);
#ifdef CRAYTRACE
        nb = read(fp,junkbuf,NB_THEADER); /* bypass CRAY header */
        if(nb <= 0)
        {
                printf("Read error after rewinding CRAY log file");
                close(fp);
                done = 1;
                go = 0;
        }
#endif
        save_init_clock = initial_clock;
        initialize();
        initial_clock = save_init_clock;
        last_real_clock=initial_clock;
        first_time = 1;
        data_input();
}
#endif
