static char USMID[] = "@(#)process.c	1.1 10/16/90 11:03:58 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#endif /* sunview */
#ifdef X11
#include "xexterns.h"
#endif
#include "externvars.h"
#include "log_entry.h"

/**********************************************************
 * This file contains the routines to allocate space for 
 * a task and process the task and its events.
 *
 *********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#ifdef sunview
extern Panel_item event_count,process_count,task_count,clock_count;
#endif /* sunview */

process_event()
{
/**************************************************************
 * process_event is called after the information is read in.
 * The relevant information has been placed in
 * global variables and will be used appropriately.
 *************************************************************/
	int i;

	if (curr_id != 0) {			/* Ignore Killer Events */
		if (!check_nonpost_events())
		{
			update_task();
			for (i=0; i < MAXCOLUMNS; i++)
			{
				if (screen[i].taskid != 0)
				{
					update_column(screen[i].taskid);
				}
			}
			ypos += NODEHEIGHT;	/* update y position */
		}
	}

	if ((ypos % (NODEHEIGHT * 20) == 0 ))	/*Display id's every 20 events*/
	{
		display_task_id();
	}
}


update_task()
{
/***************************************************
 * update the curr task in preparation for drawing *
****************************************************/
	char str[30];
    
    
#ifdef CRAYTRACE
	/*new task or lost info except if curr_id==0 then it's a Killer event */
	/* new task or lost info */
	if(( curr_id > 0 ) && (tasks[curr_id].x == 0))
#endif CRAYTRACE
#ifdef CTSSTRACE
	if(tasks[curr_id].x == 0 )
#endif CTSSTRACE
	{
		curr_tasks++;
		assign_x(curr_id);
		sprintf(str,"Number of	Tasks: %d",curr_tasks);
#ifdef sunview
		panel_set(task_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
		XClearArea(control_display,control_win,
			424, 90, 150, 13, True);
		XDrawString(control_display,control_win,canvas_gc,
			424,100,str,strlen(str));
		XFlush(control_display);
#endif
	}
	tasks[curr_id].post_event = curr_action;  /* post significant events */
	switch (curr_action)
	{
		case LIGHT:		case START:
		case COMPLETED:		case RECOVER:
		case BIND:		case UNBIND:
			task_actions_switch();
		break;
		case REQUEST:
#ifdef CRAYTRACE	/* COS only */
		case REQUEST_NA:
#endif CRAYTRACE
			sprintf(node_str,"ReqPro");
		break;
		case TWAIT:	case TNWAIT:	case TRESUME:
		case LWAIT:	case LNWAIT:	case LRESUME:
		case EWAIT:	case ENWAIT:	case ERESUME:
			wait_switch();
		break;
		case ECLEAR:	case EPOST:	case EASSIGN:
		case ERELEASE:	case ETEST:
		case LASSIGN:	case LRELEASE:	case LCLEAR:
		case LTEST:	case TTEST:
			sync_switch();
		break;
		case BASSIGN:	case BRELEASE:	case BWAIT:
		case BNWAIT:	case BRESUME:
			barrier_switch();
		break;
		case GNWAIT:	case GNRESUME:	case GWAIT:
		case GRESUME:	case SINIT: 
/*  The following case variables are current reserved for user buffers in
 *  CRAY dumps.	  In the future they may be used for microtasing.   Until
 *  then they should be treated as user buffer variables when coming from
 *  CRAY tracefiles.
*/
#ifdef CTSSTRACE			/* This is for TIR 11770 */
		case MSTARTF:	case MWAITF:
		case MRESUMEF:	case CSWAIT:	case SSTARTF:
		case CSRESUME:	case SEXIT:
#endif

		case CSNWAIT:	case SWAITW: 
			micro_task_switch();
		break;
		default:	
		break;
	}
}

task_actions_switch()
{
/*********************************************************
 * task_actions_switch is the switch that handles task
 * actions such as And Then There Was Light, Start Task,
 * Complete Task, Recover Task, and Bind and Unbind Task,
 * updating appropriate variables and structures.
 **********************************************************/
	char str[30];

	switch(curr_action)
	{
	case LIGHT :
		update_first();
		break;
	case START :
		tasks[curr_id].process_state = -1;  /* initially not bound */
		tasks[curr_id].wait_state = 0;
		tasks[curr_id].parent = (int)aux_data[0];
		/* set last log time of parent to indicate he has been
		 * doing something */
		tasks[tasks[curr_id].parent].last_time_log = real_clock;
		break;
	case COMPLETED :
		if( curr_procs > 0 )
		{
#ifdef CTSSTRACE
			if((procs[curr_process].state == 3) ||
				(procs[curr_process].task >-1))
#endif CTSSTRACE
			curr_procs--;	/*  No explicit unbinds for completes */
		}
#ifdef CRAYTRACE
		curr_process = tasks[curr_id].process_state;
		curr_tasks--;
		sprintf(str,"Number of	Tasks: %d",curr_tasks);
#ifdef sunview
		panel_set(task_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
		XClearArea(control_display,control_win,
			424, 90, 150, 13, True);
		XDrawString(control_display,control_win,canvas_gc,
			424,100,str,strlen(str));
		XFlush(control_display);
#endif
#endif
		tasks[curr_id].process_state = -1;
		procs[curr_process].task = -1;	   /* now no task id */
		procs[curr_process].state = 4;
		tasks[curr_id].wait_state = 1;	/* Waiting to be recovered... */
		tasks[curr_id].process_state = -1;  
		break;
	case RECOVER :
		tasks[curr_id].parent = 0;
		tasks[curr_id].wait_state  = 0;
		tasks[curr_id].process_state = -1;
		break;
	case BIND :
		if (tasks[curr_id].x == 0) return(1);
#ifdef CTSSTRACE
		if ((procs[curr_process].state == 4) ||
			(procs[curr_process].task == -1))
#endif CTSSTRACE
		curr_procs++;
		tasks[curr_id].process_state = curr_process;
		procs[curr_process].task = curr_id;
		procs[curr_process].state = 3;
		break;
	case UNBIND :
		if (tasks[curr_id].x == 0) return(1);
#ifdef CTSSTRACE
		if ((procs[curr_process].state	== 3) ||
			(procs[curr_process].task  > -1))
#endif CTSSTRACE
		curr_procs--;
		tasks[curr_id].process_state = -1;
		procs[curr_process].task = -1;	 /* now no task id */
		procs[curr_process].state = 4;
		break;
	default :
		break;
	}
	/* update Processes on Panel */
	sprintf(str,"Active Processes: %d",curr_procs);
#ifdef sunview
	panel_set(process_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
	XClearArea(control_display,control_win,
		424, 60, 150, 13, True);
	XDrawString(control_display,control_win,canvas_gc,
		424,70,str,strlen(str));
	XFlush(control_display);
#endif
}

wait_switch()
{
/********************************************************
 * wait_switch handles wait events such as Wait on a
 * Task/Lock/Event, No Wait on a Task/Lock/Event,
 * Resume after a Wait on a Task/Lock/Event.
 *******************************************************/

	switch(curr_action)
	{
		case TWAIT :
			sprintf(node_str,"WT :%2d",tasks[curr_id].wait_state);
			tasks[curr_id].wait_state = (int)aux_data[0];
			break;
		case LWAIT :
			tasks[curr_id].wait_state = (int)aux_data[0];
			sprintf(node_str,"WL :%2d",
				check_value(tasks[curr_id].wait_state,1));
			break;
		case EWAIT :
			tasks[curr_id].wait_state = (int)aux_data[0];
			sprintf(node_str,"WE :%2d",
				check_value(tasks[curr_id].wait_state,0));
			break;
		case TNWAIT :
			tasks[curr_id].aux_item = (int)aux_data[0];
			sprintf(node_str,"NWT:%2d",tasks[curr_id].aux_item);
			tasks[curr_id].wait_state = 0;
			break;
		case LNWAIT :
			tasks[curr_id].aux_item = (int)aux_data[0];
			sprintf(node_str,"NWL:%2d",
				check_value(tasks[curr_id].aux_item,1));
			tasks[curr_id].wait_state = 0;
			break;
		case ENWAIT :
			tasks[curr_id].aux_item = (int)aux_data[0];
			sprintf(node_str,"NWE:%2d",
				check_value(tasks[curr_id].aux_item,0));
			tasks[curr_id].wait_state = 0;
			break;
		case TRESUME :
		case LRESUME :
		case ERESUME :
			sprintf(node_str,"RESUME");
			tasks[curr_id].wait_state = 0;
			break;
		default :
			sprintf(node_str,"%d",curr_action);
			break;
	}
}

sync_switch()
{
/********************************************************
 * synch_switch handles synchronization events on Tasks,
 * Locks, and Events.
 *******************************************************/

	tasks[curr_id].aux_item = (int)aux_data[0];
#ifdef CTSSTRACE
	tasks[curr_id].wait_state = 0; /* in case resume is missing */
#endif CTSSTRACE

	switch (curr_action)
	{
		case ECLEAR :
			sprintf(node_str,"ClE:%2d",
				check_value(tasks[curr_id].aux_item,0));
			break;
		case EPOST :
			sprintf(node_str,"PsE:%2d",
				check_value(tasks[curr_id].aux_item,0));
			break;
		case LASSIGN :
			sprintf(node_str,"AsL:%2d",
				check_value(tasks[curr_id].aux_item,1));
			break;
		case EASSIGN :
			sprintf(node_str,"AsE:%2d",
				check_value(tasks[curr_id].aux_item,0));
			break;
		case LRELEASE :
			sprintf(node_str,"RlL:%2d",
				check_value(tasks[curr_id].aux_item,1));
			break;
		case ERELEASE :
			sprintf(node_str,"RlE:%2d",
				check_value(tasks[curr_id].aux_item,0));
			break;
		case LCLEAR :
			sprintf(node_str,"ClL:%2d",
				check_value(tasks[curr_id].aux_item,1));
			break;
		case TTEST :
			sprintf(node_str,"TsT:%2d",tasks[curr_id].aux_item);
			break;
		case LTEST :
			sprintf(node_str,"TsL:%2d",
				check_value(tasks[curr_id].aux_item,1));
			break;
		case ETEST :
			sprintf(node_str,"TsE:%2d",
				check_value(tasks[curr_id].aux_item,0));
			break;
	}
}


barrier_switch()
{
/******************************************************
 * barrier_switch handles the barrier events such as
 * Assign, Release, Wait, No Wait, and Resume.
 *****************************************************/
	tasks[curr_id].aux_item = (int)aux_data[0];
	switch (curr_action)
	{
		case BASSIGN :
			sprintf(node_str,"AsB:%2d",
				check_value(tasks[curr_id].aux_item,2));
			break;
		case BRELEASE :
			sprintf(node_str,"RlB:%2d",
				check_value(tasks[curr_id].aux_item,2));
			break;
		case BWAIT :
			sprintf(node_str,"WB :%2d",
				check_value(tasks[curr_id].aux_item,2));
			tasks[curr_id].wait_state = (int)aux_data[0];
			break;
		case BNWAIT :
			sprintf(node_str,"NWB:%2d",
				check_value(tasks[curr_id].aux_item,2));
			tasks[curr_id].wait_state = 0;
			break;
		case BRESUME :
			sprintf(node_str,"RESUME");
			tasks[curr_id].wait_state = 0;
			break;
		default :
			break;
	}
}

micro_task_switch()
{
/*******************************************************
 * micro_task_switch handles the microtasking events.
 ******************************************************/
    
	switch (curr_action)
	{
		case GNWAIT :
			sprintf(node_str,"WGN:%2d",(int)aux_data[0]);
			tasks[curr_id].wait_state = (int)aux_data[0];
			break;
		case GNRESUME :
			sprintf(node_str,"RESUME");
			tasks[curr_id].aux_item = (int)aux_data[0];
			tasks[curr_id].wait_state = 0;
			break;
		case GWAIT :
			sprintf(node_str,"WG");
			tasks[curr_id].wait_state = !0;	 /* ARE waiting */
			break;
		case GRESUME :
			sprintf(node_str,"RESUME");
			tasks[curr_id].wait_state = 0;
			break;
		case SINIT :
			sprintf(node_str,"SINIT");
			break;
		case MSTARTF :
			sprintf(node_str,"MStF");
			break;
		case MWAITF :
			sprintf(node_str,"MWaitF");
			/* task number */
			tasks[curr_id].wait_state = (int)aux_data[0];
			break;
		case MRESUMEF :
			sprintf(node_str,"RESUME");
			/* task number */
			tasks[curr_id].aux_item = (int)aux_data[0];
			tasks[curr_id].wait_state = 0;
			break;
		case CSWAIT :
			sprintf(node_str,"WaitCS");
			/* task number */
			tasks[curr_id].wait_state = (int)aux_data[0];
			break;
		case CSNWAIT :
			sprintf(node_str,"NWCS");
			/* task number */
			tasks[curr_id].aux_item = (int)aux_data[0];
			tasks[curr_id].wait_state = 0;
			break;
		case CSRESUME :
			sprintf(node_str,"RESUME");
			/* task number */
			tasks[curr_id].aux_item = (int)aux_data[0];
			tasks[curr_id].wait_state = 0;
			break;
		case SWAITW :
			/* task number */
			tasks[curr_id].aux_item = (int)aux_data[0]; 
			/* is waiting */
			tasks[curr_id].wait_state = !0;
			sprintf(node_str,"SWait");
			break;
		case SSTARTF :
			/* task number */
			tasks[curr_id].aux_item = (int)aux_data[0];
			sprintf(node_str,"StartF");
			break;
		case SEXIT :
			/* task number */
			tasks[curr_id].aux_item = (int)aux_data[0];
			sprintf(node_str,"ExitS");
			break;
		default :
			break;
	}
}
	  
check_nonpost_events()
{
/*********************************************************
 * check_nonpost_events filters out all of the events
 * which do not correspond to specific tasks. Returns 1
 * if the event was a nontask event, else returns 0.
 *********************************************************/
#ifdef sunview
	extern Frame frame;
	extern Pixwin *pw;
	extern struct pixfont *node_font;
#endif sunview

	switch (curr_action)
	{
		case ACQUIRE :
			/* now acquired but unbound */
			procs[curr_process].state = 4;
			draw_process();
		break;
		case IDLE :
			procs[curr_process].state = 0;
			draw_process();
		break;
		case SUSPEND :
			procs[curr_process].state = 1;
			draw_process();
		break;
		case REACQUIRE :
		case REQSUS:
			procs[curr_process].state = 2;
			draw_process();
		break;
		case LOST :
#ifdef sunview
			window_bell(frame);
			pw_text(pw,200,ypos+12,PIX_SRC,node_font,node_str);
#endif sunview
#ifdef X11
			XBell(canvas_display,0);
			XDrawString(canvas_display,can_win,canvas_gc,
				200,ypos+12,node_str,strlen(node_str));
#endif X11
			display_message("Logged events lost - view is invalid\n");
			display_message("To Avoid: use larger log buffer or call lgflush \n");
			sprintf(node_str,"!!!LOST DATA!!!LOST DATA!!!LOST DATA!!!");

		break;
		default :
		/* Check for and ignore killer actions */
		if (curr_id == 0)
		{
			return(1);
		} else
		{
			return(0);
		}
	}
	return(1);
}	  

significant_event()
{
/***************************************
 * Returns a 1 if a the action is a significant
 * event, otherwise returns 0
 ***************************************/
	if (curr_id == 0) 
	{
		return(0);
	} else
	{
		switch (curr_action)
		{
			case ACQUIRE :
			case IDLE :
			case SUSPEND :
			case REACQUIRE :
#ifdef CRAYTRACE
			case REQSUS:
			case LOST :
#endif CRAYTRACE
				return(0);
			default :
				return(1);
		}
	}
}


update_column(id)
int id;
{
/***************************************
 * posts an event,  or updates
 * the line, and binds/unbinds
 **************************************/

	int x, y;		/* coordinates in the primary canvas */
	int event;
	char str[10];

	x = tasks[id].x;
	y = ypos;
	event = tasks[id].post_event;
#ifdef CRAYTRACE
	if (event != -1)
#endif CRAYTRACE
#ifdef CTSSTRACE
	if (event != 0)
#endif CTSSTRACE
	{
		draw_event(id);
	} else
	{
		draw_wait_state(id);
		if (tasks[id].process_state != -1)	/* is bound */
		{
			draw_bound_state(id);
		}
	}
}


update_first()
{
/***************************************
 * update_first initializes structures
 * and sets up the first task, with an
 * implied Start Task, which is drawn
 * in special_draw_switch.
 **************************************/
	char str[40];

	tasks[curr_id].x = ((PCX/2) - (COLUMNWIDTH/2)) +CENTER;
	tasks[curr_id].process_state = 0;
	tasks[curr_id].wait_state = 0;
	tasks[curr_id].parent = 0;
	procs[0].task = 1;
	procs[0].state = 3;	/* First process is bound to first task */
#ifdef CRAYTRACE
	procs[0].pid = log_entry.lo_user;
#endif
	screen[(MAXCOLUMNS-1) / 2].taskid = 1;

	curr_procs++;

	sprintf(str,"Active Processes: %d",curr_procs);
#ifdef sunview
	panel_set(process_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
	XClearArea(control_display,control_win,
		424, 60, 150, 13, True);
	XDrawString(control_display,control_win,canvas_gc,
		424,70,str,strlen(str));
/*	XFlush(control_display); */
#endif
}
