static char USMID[] = "@(#)xkey.c	1.1 10/16/90 11:11:53 LLNL ";
#ifdef X11
#include "xexterns.h"
#include "externvars.h"

/*************************************************************
 * This file contains the routines to bring up a window 
 * containing a key to the various symbols used by gmat.
 * 
 **************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#include "xicons/solid.icon"		/* solid_bits[] */
#include "xicons/master.icon"		/* master_bits[] */
#include "xicons/hollow.icon"		/* hollow_bits[] */
#include "xicons/pbind.icon"		/* pbind_bits[] */
#include "xicons/punbind.icon"		/* punbind_bits[] */
#include "xicons/pidle.icon"		/* pidle_bits[] */
#include "xicons/psuspnd.icon"		/* psuspnd_bits[] */
#include "xicons/preacq.icon"		/* preacq_bits[] */
#include "xicons/wait_w.icon"		/* wait_w_bits[] */
#include "xicons/choice.icon"		/* choice_bits[] */
#include "xicons/key_slv.icon"		/* key_slv_bits[] */
#include "xicons/infray.icon"		/* infray_bits[] */
#include "xicons/rv_mstr.icon"	/* rv_master_bits[] */
#include "xicons/rv_chce.icon"	/* rv_choice_bits[] */
#include "xicons/rv_wait.icon"	/* rv_wait_w_bits[] */
#include "xicons/rv_key.icon"	/* rv_key_slv_bits[] */
#include "xicons/rv_sold.icon"		/* rv_solid_bits[] */
#include "xicons/rv_fray.icon"	/* rv_infray_bits[] */

static int key_up = 2;

prepare_key()
{
	char str[100];
	Arg args[10];
	XGCValues values;
	XSetWindowAttributes attr;
	Pixmap pixmap;
	Pixmap tpixmap;
	XImage *image;
	int border = 0;
	XWindowAttributes frameAttributes;

	XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
	XtSetArg(args[0],XtNx,frameAttributes.x+660);
	XtSetArg(args[1],XtNy,frameAttributes.y+50);
	XtSetValues(key_shell,args,2);
	if( key_up == 2 )
	{
		key_up = 0;
		XtPopup(key_shell,XtGrabNone);
		key_win = XtWindow(key_pop);
		key_display = XtDisplay(key_pop);
		key_scr = XtScreen(key_pop);
		values.function = GXcopy;
		values.foreground = black;
		values.background = white;
		values.plane_mask = AllPlanes;
		XtPopup(key_shell,XtGrabNone);
		key_gc = XCreateGC(key_display,key_win,
			(GCFunction | GCForeground | GCBackground | GCPlaneMask), &values);
		attr.backing_store = Always;
		attr.save_under  = True;
		XChangeWindowAttributes(key_display,key_win,
			(CWBackingStore | CWSaveUnder ),&attr);
	} else if( key_up == 1 )
	{
		XtPopup(key_shell,XtGrabNone);
		key_up = 0;
		return;
	} else
	{
		XtPopdown(key_shell);
		key_up = 1;
		return;
	}


	/* overview nodes */
	XFillRectangle(key_display,key_win,control_gc,51,11,3,3);
	strcpy(str,"task is not bound to process");
	XDrawString(key_display,key_win,control_gc,70,15,str,strlen(str));

	XDrawRectangle(key_display,key_win,control_gc,51,31,OVSQUARE-2,OVSQUARE-2);
	strcpy(str,"task is bound to process");
	XDrawString(key_display,key_win,control_gc,70,35,str,strlen(str));

	XFillRectangle(key_display,key_win,control_gc,52,52,2,OVSQUARE);
	strcpy(str,"process is not bound");
	XDrawString(key_display,key_win,control_gc,70,55,str,strlen(str));

	XFillRectangle(key_display,key_win,control_gc,50,70,OVSQUARE,OVSQUARE);
	/* clear vertical line on square */
	XClearArea(key_display,key_win,50+2,70,2,5,True);
	strcpy(str,"process is bound");
	XDrawString(key_display,key_win,control_gc,70,75,str,strlen(str));

	/* primary canvas nodes */
	strcpy(str,"UNBOUND");
	XDrawString(key_display,key_win,control_gc,5,95,str,strlen(str));
	strcpy(str,"BOUND");
	XDrawString(key_display,key_win,control_gc,350,95,str,strlen(str));

	tpixmap = XCreateBitmapFromData(key_display,
		DefaultRootWindow(key_display),solid_bits,solid_width,solid_height);
	pixmap = XCreatePixmap(key_display,DefaultRootWindow(key_display),
		solid_width,solid_height,
		DefaultDepth(key_display,DefaultScreen(key_display)));

	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);

	image = XGetImage(key_display,pixmap,0,0,solid_width,solid_height,
		AllPlanes, XYPixmap);

	XPutImage(key_display,key_win,key_gc,image,0,0,10,105,NODEDIM,NODEDIM);
	XDestroyImage(image);

	strcpy(str,"task is ready");
	XDrawString(key_display,key_win,control_gc,70,130,str,strlen(str));

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		rv_solid_bits, rv_solid_width, rv_solid_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,rv_solid_width,rv_solid_height,
		AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,350,105,NODEDIM,NODEDIM);
	XDestroyImage(image);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		master_bits, master_width, master_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,master_width,master_height,
		AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,140,NODEDIM,NODEDIM);
	XDestroyImage(image);
	strcpy(str,"enclosed task is a master");
	XDrawString(key_display,key_win,control_gc,70,165,str,strlen(str));
	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		rv_master_bits, rv_master_width, rv_master_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,rv_master_width,
		rv_master_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,350,140,NODEDIM,NODEDIM);
	XDestroyImage(image);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		hollow_bits, hollow_width, hollow_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,hollow_width,hollow_height,
		AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,175,NODEDIM,NODEDIM);
	XDestroyImage(image);
	strcpy(str,"task is completed and recovered");
	XDrawString(key_display,key_win,control_gc,70,200,str,strlen(str));

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		choice_bits, choice_width, choice_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,choice_width,choice_height,
		AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,210,NODEDIM,NODEDIM);
	XDestroyImage(image);
	strcpy(str,"task is in state N");
	XDrawString(key_display,key_win,control_gc,70,235,str,strlen(str));
	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		rv_choice_bits, rv_choice_width, rv_choice_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,rv_choice_width,
		rv_choice_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,350,210,NODEDIM,NODEDIM);
	XDestroyImage(image);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		wait_w_bits, wait_w_width, wait_w_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,wait_w_width,wait_w_height,
		AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,245,NODEDIM,NODEDIM);
	XDestroyImage(image);
	strcpy(str,"slave is waiting for work");
	XDrawString(key_display,key_win,control_gc,70,270,str,strlen(str));
	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		rv_wait_w_bits, rv_wait_w_width, rv_wait_w_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,rv_wait_w_width,
		rv_wait_w_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,350,245,NODEDIM,NODEDIM);
	XDestroyImage(image);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		key_slv_bits, key_slv_width, key_slv_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,key_slv_width,key_slv_height,
		AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,280,NODEDIM,NODEDIM);
	XDestroyImage(image);
	strcpy(str,"slave is in state N");
	XDrawString(key_display,key_win,control_gc,70,305,str,strlen(str));
	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		rv_key_slv_bits, rv_key_slv_width, rv_key_slv_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,rv_key_slv_width,
		rv_key_slv_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,350,280,NODEDIM,NODEDIM);
	XDestroyImage(image);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		infray_bits, infray_width, infray_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,infray_width,infray_height,
		AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,315,NODEDIM,NODEDIM);
	XDestroyImage(image);
	strcpy(str,"slave is working");
	XDrawString(key_display,key_win,control_gc,70,335,str,strlen(str));
	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		rv_infray_bits, rv_infray_width, rv_infray_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image = XGetImage(key_display,pixmap,0,0,rv_infray_width,
		rv_infray_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,350,315,NODEDIM,NODEDIM);
	XDestroyImage(image);

	strcpy(str,"TASK AND SLAVE STATES");
	XDrawString(key_display,key_win,control_gc,70,365,str,strlen(str));
	strcpy(str,"WT - Waiting on a task");
	XDrawString(key_display,key_win,control_gc,30,385,str,strlen(str));
	strcpy(str,"WL - Waiting on a lock");
	XDrawString(key_display,key_win,control_gc,30,405,str,strlen(str));
	strcpy(str,"WE - Waiting on an event");
	XDrawString(key_display,key_win,control_gc,30,425,str,strlen(str));
	strcpy(str,"WB - Waiting on a barrier");
	XDrawString(key_display,key_win,control_gc,30,445,str,strlen(str));
	strcpy(str,"WF - Waiting on a fray");
	XDrawString(key_display,key_win,control_gc,30,465,str,strlen(str));
	strcpy(str,"GN - Waiting on guard N");
	XDrawString(key_display,key_win,control_gc,30,485,str,strlen(str));
	strcpy(str,"G  - Waiting on a guard");
	XDrawString(key_display,key_win,control_gc,30,505,str,strlen(str));
	strcpy(str,"CS - Waiting on a control structure");
	XDrawString(key_display,key_win,control_gc,30,525,str,strlen(str));

	strcpy(str,"User-Defined Significant Action Numbers (0 = undefined)");
	XDrawString(key_display,key_win,control_gc,5,550,str,strlen(str));
	sprintf(str,"Choice 1: Action Number %d",choice[1]);
	XDrawString(key_display,key_win,control_gc,105,565,str,strlen(str));
	sprintf(str,"Choice 2: Action Number %d",choice[2]);
	XDrawString(key_display,key_win,control_gc,105,580,str,strlen(str));
	sprintf(str,"Choice 3: Action Number %d",choice[3]);
	XDrawString(key_display,key_win,control_gc,105,595,str,strlen(str));
	sprintf(str,"Choice 4: Action Number %d",choice[4]);
	XDrawString(key_display,key_win,control_gc,105,610,str,strlen(str));
	sprintf(str,"Choice 5: Action Number %d",choice[5]);
	XDrawString(key_display,key_win,control_gc,105,625,str,strlen(str));

/* process icons */
	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		pbind_bits, pbind_width, pbind_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image  = XGetImage(key_display,pixmap,0,0,pbind_width,
			pbind_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,635,
			ICONHEIGHT,ICONWIDTH);
	XDestroyImage(image);
	XDrawString(key_display,key_win, control_gc,60,660, "process is bound",16);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		pidle_bits, pidle_width, pidle_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image  = XGetImage(key_display,pixmap,0,0,pidle_width,
			pidle_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,210,635,
			ICONHEIGHT,ICONWIDTH);
	XDestroyImage(image);
	XDrawString(key_display,key_win,control_gc,260,660,"process is idle",15);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		psuspend_bits, psuspend_width, psuspend_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image  = XGetImage(key_display,pixmap,0,0,psuspend_width,
			psuspend_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,680,
			ICONHEIGHT,ICONWIDTH);
	XDestroyImage(image);
	XDrawString(key_display,key_win,control_gc,60,705,
			"process is suspended",20);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		preacq_bits, preacq_width, preacq_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image  = XGetImage(key_display,pixmap,0,0,preacq_width,
			preacq_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,210,680,
			ICONHEIGHT,ICONWIDTH);
	XDestroyImage(image);
	XDrawString(key_display,key_win,control_gc,255,705,
			"process is reacquired",21);

	tpixmap = XCreateBitmapFromData(key_display,DefaultRootWindow(key_display),
		punbind_bits, punbind_width, punbind_height);
	XCopyPlane(key_display,tpixmap,pixmap,key_gc,0,0,
		solid_width, solid_height, 0,0,1);
	image  = XGetImage(key_display,pixmap,0,0,punbind_width,
			punbind_height, AllPlanes, XYPixmap);
	XPutImage(key_display,key_win,key_gc,image,0,0,10,725,
			ICONHEIGHT,ICONWIDTH);
	XDestroyImage(image);
	XDrawString(key_display,key_win,control_gc,60,750,"process is unbound",18);
}
#endif
