static char USMID[] = "@(#)open_dump.c	1.1 10/16/90 11:11:41 LLNL ";
#if sun
#include<sys/file.h>
#endif
#if CRAY2 || CRAY
#include <fcntl.h>
#endif
#include<errno.h>

extern int errno;
extern char dumpfile[];
extern int fd;

/************************************************************
 * This file contains the routine to prompt the user for a
 * filename for the dump file, checks to see if the file 
 * already exists, and if so prompts the user to confirm
 * the overwrite.  The file descriptor of the opened file
 * is returned.
 * 
 ***********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */
 

/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

int open_dumpfile()
{
    char confirm[80];
    
    fd = -1;
    printf("\nIn Dynamic Mode, the data will be dumped to a file\n");
    printf("for later review in Static Mode.  The filename must \n");
    printf("begin with the letters 'trace' . \n");

    while (fd < 0) {
	printf("\nEnter file name: ");
	scanf("%s",dumpfile);

	fd = open(dumpfile,O_WRONLY | O_CREAT | O_EXCL);

	if (fd < 0) {
	  if (errno == 17) {
	      printf("\nOverwrite Existing File: (confirm y/n)  ");
	      scanf("%s",confirm);
	      if (confirm[0] == 'y')  {
		  fd = open(dumpfile,O_WRONLY | O_CREAT);
		  if ((fd < 0) && (errno == 13))
		    printf("Permission denied to overwrite file\n");
	      }  /* end if */
	  }   /* end if */
	  else
	    printf("\nError in opening %s\n", dumpfile);
	}    /* end if */
    }    /* end while */
    return(fd);
}    /* end open_dumpfile */
