static char USMID[] = "@(#)doevents.c	1.1 10/16/90 11:11:25 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/scrollbar.h>
#include "externvars.h"

/**********************************************************************
 * Handles events in the primary canvas subwindow and the overview
 * subwindow.
 *
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern Scrollbar pcv_bar, pch_bar;
extern Frame misc_frame;
extern Pixwin *mpw;

void  handle_pcevent(canvas, event, arg)
Canvas canvas;
Event *event;
caddr_t arg;
{
/*********************************************************
 * handles events in the primary canvas subwindow.
 ********************************************************/
    int x,y,rightid;
    char str[20];
    int localx,localy;
    Event *temp;

    x = event_x(event);
    y = event_y(event);
    temp = canvas_window_event(canvas,event);
    localx = event_x(temp) + 50; 	/* position in frame */
    localy = event_y(temp) + 283 + 50;  /* height of OV + 50 offset */
    if (localx > (960 - 175)) {
	localx = 960 - 175;
    }
    if (localy > (900 - 200)) {
	localy = 900 - 200;
    }
    switch (event_id(event)) {
	/* NOTE:  pressing the mouse button down is one event, and 
           releasing it is another.  If the button is pressed down
	   and released while on a node of the graph - the current
	   node message will be displayed twice.   */
      case MS_LEFT:

#ifdef DEBUG
	printf("Primary Canvas: Left mouse x %d y %d \n",x,y);  
#endif
	leftid = pixel_to_id(x,y);
	if (event_is_down(event)) 
	  if (leftid == -1)
	    display_message("Cursor is not positioned on a node\n");
	  else {
	      sprintf(str,"Current node is %d\n",leftid);
	      display_message(str);
	  }
	break;
      case MS_MIDDLE:

#ifdef DEBUG
	printf("Primary Canvas: Middle Mouse x %d y %d \n",x,y); 
#endif
	break;
      case MS_RIGHT:

#ifdef DEBUG
	printf("Primary Canvas: Right mouse x %d y %d \n",x,y); 
#endif
	/* show the canvas on a down motion and hide on an up motion */
	if (event_is_up(event))
	  window_set(misc_frame, WIN_SHOW, FALSE, 0);
	else {
	    window_set(misc_frame, WIN_SHOW, FALSE, 0); /* in case visible */
	    rightid = pixel_to_id(x,y);
	    if (rightid == -1)
	      display_message("Cursor is not positioned on a node\n");
	    else {
		clearscreen(mpw,INFOX,INFOY);
		window_set(misc_frame,
			   WIN_X,	localx,
			   WIN_Y,	localy,
			   WIN_SHOW,	TRUE,
			   0);
		display_info(rightid);
	    }
	}
	break;
      default:
	break;
    }   /* end switch */
}   /* end handle_event */



void  handle_ovevent(canvas, event, arg)
Canvas canvas;
Event *event;
caddr_t arg;
{
    int x,y;
    int pcx, pcy;
    char str[20];

    x = event_x(event);
    y = event_y(event);
    switch (event_id(event)) {
      case MS_LEFT:
#ifdef DEBUG
	printf("Overview: Left Mouse x %d y %d \n",x,y); 
#endif
	if (event_is_down(event)) {
	    draw_view_box(x,y);
	    if (x > 380) x = 380;
	    if (y > 280) y = 280;
	    pcx = (x * SCALEUP) + BORDER;  /* handle border */
	    pcy = (y * SCALEUP);
	    if (pcx < ((VIEWWIDTH+110)/2)) pcx = 0;
	    else pcx = (pcx - ((VIEWWIDTH+110)/2));
	    if (pcy < (VIEWHEIGHT/2)) pcy = 0;
	    else pcy = (pcy - (VIEWHEIGHT/2));
	    scrollbar_scroll_to(pch_bar,pcx);
	    scrollbar_scroll_to(pcv_bar,pcy);  
	}
	break;
      case MS_MIDDLE:

#ifdef DEBUG
	printf("Overview: Middle Mouse x %d y %d \n",x,y); 
#endif
	break;
      case MS_RIGHT:

#ifdef DEBUG
	printf("Overview: Right mouse x %d y %d \n",x,y); 
#endif

	break;
      default:
	break;
    }   /* end switch */
}   /* end handle_ovevent */


pixel_to_id(x,y)
int x, y;
{ 
/************************************************************
 * Calculate the row and column containing a given x,y 
 * coordinate in the Primary Canvas and determine the node id.
 * Returns -1 if the coords do not correspond to a node.
 ***********************************************************/
    int arrayrefx, arrayrefy, xy_id;

    arrayrefx = ( (x-BORDER) / PCSQUARE ) - ( ( x % PCSQUARE) / PCSQUARE );
    arrayrefy = ( (y-BORDER) / PCSQUARE ) - ( ( y % PCSQUARE) / PCSQUARE );
    
    xy_id = screen[arrayrefx][arrayrefy].id;
    
    if (xy_id == 0)
      return(-1);
    else
      return(xy_id);
}

void  handle_miscevent(canvas, event, arg)
Canvas canvas;
Event *event;
caddr_t arg;
{
/*********************************************************
 * handles events in the misc canvas subwindow.
 ********************************************************/

    switch (event_id(event)) {
      case MS_LEFT:
	break;
      case MS_MIDDLE:
	break;
      case MS_RIGHT:
	if (event_is_up(event))			/* Hide the canvas on an up event */
	  window_set(misc_frame, WIN_SHOW, FALSE, 0);
	break;
      default:
	break;
    }   
}

display_info(id)
int id;
{
/**************************************************
 * Displays information pertaining to the node
 * the user indicated. Information is displayed
 * in a canvas subwindow.
 *************************************************/
    char str[30];
    int i;
    struct act_struct *temp;

    pw_text(mpw,10,10,PIX_SCR,0,"NODE INFORMATION");
    sprintf(str,"Task Number: %d",id);
    pw_text(mpw,10,30,PIX_SCR,0,str);
    if (id != 1) {
	sprintf(str,"Parent Number: %d",tasks[id]->parent);
	pw_text(mpw,10,45,PIX_SCR,0,str);
    }
    switch (tasks[id]->state) {
      case TWAIT :
	sprintf(str,"Waiting on task %d",tasks[id]->aux_item);
	pw_text(mpw,10,60,PIX_SCR,0,str);
	break;
      case EWAIT :
	pw_text(mpw,10,60,PIX_SCR,0,"Waiting on event");
	sprintf(str,"  at address %d",tasks[id]->aux_item);
	pw_text(mpw,10,75,PIX_SCR,0,str);
	break;
      case LWAIT :
	pw_text(mpw,10,60,PIX_SCR,0,"Waiting on lock");
	sprintf(str,"  at address %d",tasks[id]->aux_item);
	pw_text(mpw,10,75,PIX_SCR,0,str);
	break;
      case BWAIT :
	pw_text(mpw,10,60,PIX_SCR,0,"Waiting on Barrier");
	sprintf(str,"  at address %d",tasks[id]->aux_item);
	pw_text(mpw,10,75,PIX_SCR,0,str);
	break;
      case GNWAIT :
	if (tasks[id]->slave == -1)  /* is master */
	  sprintf(str,"Master of the Fray");
	else
	  sprintf(str,"Slave for task %d",tasks[id]->slave);
	sprintf(str,"Waiting on Guard %d",tasks[id]->aux_item);
	pw_text(mpw,10,75,PIX_SCR,0,str);
	break;
      case GWAIT :
	if (tasks[id]->slave == -1)  /* is master */
	  sprintf(str,"Master of the Fray");
	else
	  sprintf(str,"Slave for task %d",tasks[id]->slave);
	pw_text(mpw,10,60,PIX_SCR,0,str);
	pw_text(mpw,10,75,PIX_SCR,0,"Waiting on Guard");
	break;
      case MSTARTF :
	pw_text(mpw,10,60,PIX_SCR,0,"Master Started Fray");
	break;
      case MWAITF :
	pw_text(mpw,10,60,PIX_SCR,0,"Master waiting on Fray");
	break;
      case CSWAIT :
	if (tasks[id]->slave == -1) /* is master */
	  sprintf(str,"Master of the Fray");
	else 
	  sprintf(str,"Slave for task %d",tasks[id]->slave);
	pw_text(mpw,10,60,PIX_SCR,0,str);
	pw_text(mpw,10,75,PIX_SCR,0,"Waiting on Control Strucutre");
	break;
      case SWAITW :
	sprintf(str,"Slave waiting for work");
	pw_text(mpw,10,60,PIX_SCR,0,str);
	break;
      case GNRESUME :
      case GRESUME :
      case CSRESUME :
	if (tasks[id]->slave == -1)  /* is master */
	  sprintf(str,"Master of the Fray");
	else
	  sprintf(str,"Slave for task %d",tasks[id]->slave);
	pw_text(mpw,10,60,PIX_SCR,0,str);
	break;
      default :
	if (tasks[id]->slave == -1)
	  pw_text(mpw,10,60,PIX_SCR,0,"Master of the Fray");
	else if (tasks[id]->slave >= 0)  {
	    sprintf(str,"Slave for task %d",tasks[id]->slave);
	    pw_text(mpw,10,60,PIX_SCR,0,str);
	}
    }
    pw_text(mpw,10,93,PIX_SCR,0,"Most Recent Events");
    pw_text(mpw,10,105,PIX_SCR,0,"------------------");
    temp = tasks[id]->actions;
    for (i=0; temp != NULL; i++) {
	sprintf(str, "Action Number:  %d",temp->action);
	pw_text(mpw,5,120 + (15*i),PIX_SCR,0,str);
	temp = temp->next;
    }
}
#endif
