h41429
s 00025/00000/00724
d D 1.2 90/10/22 13:25:50 werner 2 1
c Added eventhandlers to intercept Button presses for popup windows.
e
s 00724/00000/00000
d D 1.1 90/10/16 11:11:57 werner 1 0
c date and time created 90/10/16 11:11:57 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef X11
#include "xexterns.h"
#ifdef X11R3
#include <X11/Scroll.h>
#else
#include <X11/Xaw/Scroll.h>
#endif
#include "externvars.h"
#include "xicons/pbind.icon"
#include "xicons/punbind.icon"
#include "xicons/solid.node"

/**********************************************************************
 * This file contains the routines static_init() and dynamic_init(),
 * which initilize the windows and defines their placement.
 *
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */
 

/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern char dumpfile[];

extern void handle_pcevent(), load_notify_proc(), go_notify_proc();
extern void step_notify_proc(), prepare_key(), subtree_notify_proc();
extern void hist_notify_proc(), quit_notify_proc(), handle_ovevent();
extern void handle_pcevent(), handle_ovevent(), handle_miscevent();
extern void execQuit();
extern void cancelQuit();

static Widget quit_cancel_button, quit_execute_button;
static Widget quit_pop, quit_question;

#include "xicons/sg.icon"
Pixmap sg_pixmap;
Window frame_wid;		/* used to expose window */

I 2



/* intercepts events that you do not want to reach the root window */
void  popdummy(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
	return;
}


E 2
void dirMenu(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
	XWindowAttributes frameAttributes;

	XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
	XtSetArg(args[0],XtNx,frameAttributes.x+195);
	XtSetArg(args[1],XtNy,frameAttributes.y+55);
	XtSetValues(dir_shell,args,2);

	XtSetSensitive(directory_choice,False);
	XtPopup(dir_shell,XtGrabNone);
	return;
}

void fileMenu(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
	XWindowAttributes frameAttributes;

	XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
	XtSetArg(args[0],XtNx,frameAttributes.x+148);
	XtSetArg(args[1],XtNy,frameAttributes.y+75);
	XtSetValues(file_shell,args,2);

	XtPopup(file_shell,XtGrabNone);
	return;
}

static char *key_title = "              Key to GMAT Symbols";
static char *hist_title = "       GMAT Histogram - Events Procesed versus Active Processes";
static char *stategraph_title = "              GMAT State Graph         ";

extern XImage *bind_image;
extern int bind_FLAG;
extern XImage *unbind_image;
extern int unbind_FLAG;
extern XImage *solid_image;
extern int solid_FLAG;
XFontStruct *font_info2;
int frame_x, frame_y;
unsigned int depth;

static_init(argc,argv)
int *argc;
char **argv;
{
	Pixmap bitmap;
	Pixmap pixmap;
	int i;
	int c;
	static char dash_list[] = { 4,4 };
	Screen *s;
	XGCValues values;
	XSetWindowAttributes attr;
	XWindowAttributes frameAttributes;
	int rv = 0;
	extern char *optarg;
	extern int opterr;

	/* This is my way of getting whether things are to be reverse videod or 
	 * not. */
	opterr = 0;
	while ((c = getopt(*argc,argv,"r:")) != EOF)
	{
		switch(c)
		{
			case 'r':
				if( *optarg == 'v' )
				{
					rv = 1;
				}
				break;
			default:
				break;
		}
	}

	frame = XtInitialize("xstategraph","GMAT", NULL, 0, &(*argc), argv);
    
	s = XtScreen(frame);
	display_control = XtDisplay(frame);
	if( rv == 0 )
	{
		black = BlackPixel(display_control,DefaultScreen(display_control));
		white = WhitePixel(display_control,DefaultScreen(display_control));
	} else
	{
		white = BlackPixel(display_control,DefaultScreen(display_control));
		black = WhitePixel(display_control,DefaultScreen(display_control));
	}
	depth = DisplayPlanes(XtDisplay(frame),
			DefaultScreen(XtDisplay(frame)));

	display_control = XtDisplay(frame);
	sg_pixmap = XCreateBitmapFromData(display_control,
				DefaultRootWindow(display_control), sg_bits,
				sg_width, sg_height);
	XtSetArg(args[0], XtNiconPixmap, sg_pixmap);
	XtSetValues(frame, args, 1);


	/* Create the stategraph widget.  This will be the 4 window:
	 * control_widget, message_widget, canvas, and overview_canvas. */
	panel = XtCreateManagedWidget("stategraph",formWidgetClass,
			  frame, NULL, 0);
	
	/* Create the font for usage throughout stategraph; */
	/* If this font disapears from the font library we'll have problems */
	if ((font_info2 = XLoadQueryFont(XtDisplay(panel), "fixed")) == NULL )
	{
#ifdef STDERR
		fprintf(stderr,"XLoadQueryFont: unable to open font 'fixed'\n");
#else
		msghan(5,1,"fixed");
#endif
		exit(0);
	}

	create_control_window();
	create_overview_window();
	create_message_window();
	create_can_window();
	create_misc();
	create_hist();

	/* get the canvas to the correct size. */
	XtRealizeWidget(frame); 	/* realize everything */
	XtResizeWidget(inner_canvas,3800,2800,0);
	XtMoveWidget(inner_canvas,-1400,0);	/* reposition to center */
	XtRealizeWidget(subtree_shell);
	/* get the subtree to the correct size. */
	XtResizeWidget(subtree_frame,3800,2800,0);
	XtMoveWidget(subtree_frame,-1400,0);	/* reposition to center */
	XtRealizeWidget(hist_shell);
	XtRealizeWidget(node_shell);
	/* get the history to the correct size. */
	XtResizeWidget(inner_hist,MAXHIST,220,0);


	frame_wid = XtWindow(frame);
	XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
	frame_x = frameAttributes.x;
	frame_y = frameAttributes.y; 

	canvas_display = XtDisplay(inner_canvas);
	canvas_screen = XtScreen(inner_canvas);
	can_win = XtWindow(inner_canvas);

	ov_display = XtDisplay(canvas_full);
	ov_screen = XtScreen(canvas_full);
	ov_win = XtWindow(canvas_full);

	control_display = XtDisplay(control_widget);
	control_screen = XtScreen(control_widget);
	control_win    = XtWindow(control_widget);

	subtree_display = XtDisplay(subtree_frame);
	subtree_win = XtWindow(subtree_frame);

	text_display = XtDisplay(textsw);
	text_win    = XtWindow(textsw);

	key_display = XtDisplay(key_pop);
	key_scr = XtScreen(key_pop);

	node_display = XtDisplay(node_pop);
	node_screen = XtScreen(node_pop);
	node_win = XtWindow(node_pop);

	hist_display = XtDisplay(inner_hist);
	hist_screen = XtScreen(inner_hist);
	hist_win = XtWindow(inner_hist);


	values.function = GXcopy;
	values.foreground = black;
	values.background = white;
	values.font = font_info2->fid;
	values.fill_style = FillSolid;

	attr.backing_store = Always;
	attr.save_under = True;
	XChangeWindowAttributes(display_control, control_win,
		(CWBackingStore | CWSaveUnder), &attr);
	XChangeWindowAttributes(canvas_display, can_win,
		(CWBackingStore | CWSaveUnder), &attr);
	XChangeWindowAttributes(subtree_display, subtree_win,
		(CWBackingStore | CWSaveUnder), &attr);
	XChangeWindowAttributes(ov_display, ov_win,
		(CWBackingStore | CWSaveUnder), &attr);
	XChangeWindowAttributes(hist_display, hist_win,
		(CWBackingStore | CWSaveUnder), &attr);

	control_gc = XCreateGC(control_display, control_win,
		(GCFunction|GCFont|GCForeground|GCBackground), &values);


	box_gc = XCreateGC(ov_display, ov_win,
		(GCFunction|GCFont), &values);
	XSetLineAttributes(ov_display,box_gc,(unsigned int)1,(int)CapRound,
		(int)CapRound,(int)JoinRound);
	XSetDashes(ov_display,box_gc,(int)0,dash_list,(int)2);

	values.function = GXinvert;	/* for the rv_gc only */
	values.plane_mask = AllPlanes;
	rv_gc = XCreateGC(canvas_display, can_win,
		(GCFunction|GCForeground|GCBackground|GCPlaneMask),&values);

	values.function = GXcopy;
	values.foreground = white;
	values.background = black;
	erase_gc = XCreateGC(ov_display, ov_win,
		(GCFunction|GCForeground|GCBackground ), &values);

	node_gc = control_gc;
	hist_gc = control_gc;
	ov_gc = control_gc;

	values.function = GXcopy;
	values.foreground = black;
	values.background = white;
	values.plane_mask = AllPlanes;
	canvas_gc = XCreateGC(canvas_display, can_win,
		(GCFunction | GCForeground | GCBackground | GCPlaneMask), &values);

	display_message("No Active File\n");
	display_message("To start: load file, click Go or Step\n");
}

create_control_window()
{
	XFontStruct *font_info;
/*	static char *fontname[] = { "vr-25", "vg-25", "fg-20" }; */
	char str[80];

	static char *fontname[] = { "12x24", "12x24", "10x20" }; 
	int i;

	for( i=0; i<3; i++ )
	{
		/* do the title */
		if ((font_info = XLoadQueryFont(display_control, fontname[i])) == NULL )
		{
			sprintf(str, "XLoadQueryFont: unable to open font %s\n",
				fontname[i]);
#ifdef STDERR
			fprintf(stderr, "%s",str);
#else
			msghan(5,0,fontname[i]);
#endif
		} else
		{
			break;
		}
	}
	if( i == 3 )
	{
		strcpy(str,"XLoadQueryFont: unable to open find title fonts - using default\n");
		fprintf(stderr, "%s", str);
		font_info = font_info2;
	}

	XtSetArg(args[0],XtNwidth,	565);
	XtSetArg(args[1],XtNheight,	600);
	XtSetArg(args[2],XtNborderWidth,2);
	control_widget = XtCreateManagedWidget("gmat",formWidgetClass,
					panel, args, 3);

	XtSetArg(args[0],XtNborderWidth, 1);
	XtSetArg(args[1],XtNfromHoriz,  NULL);
	XtSetArg(args[2],XtNfromVert,	NULL);
	XtSetArg(args[3],XtNvertDistance,150);
	XtSetArg(args[4],XtNhorizDistance,20);
	XtSetArg(args[5],XtNfont,	font_info2);
	load_button = XtCreateManagedWidget("Load", commandWidgetClass,
					control_widget, args, 6);
	XtAddCallback(load_button,XtNcallback, load_notify_proc);

	XtSetArg(args[0],XtNborderWidth, 1);
	XtSetArg(args[1],XtNfromHoriz,   load_button);
	XtSetArg(args[2],XtNfromVert,    NULL);
	XtSetArg(args[3],XtNvertDistance,150);
	XtSetArg(args[4],XtNhorizDistance,20);
	XtSetArg(args[5],XtNfont,	font_info2);
	go_button = XtCreateManagedWidget("Go", commandWidgetClass,
					control_widget, args, 6);
	XtAddCallback(go_button,XtNcallback, go_notify_proc);

	XtSetArg(args[0],XtNborderWidth, 1);
	XtSetArg(args[1],XtNfromHoriz,  go_button);
	XtSetArg(args[2],XtNfromVert,   NULL);
	XtSetArg(args[3],XtNvertDistance,150);
	XtSetArg(args[4],XtNhorizDistance,20);
	XtSetArg(args[5],XtNfont,	font_info2);
	step_button =  XtCreateManagedWidget("Step", commandWidgetClass,
					control_widget, args, 6);
	XtAddCallback(step_button,XtNcallback,step_notify_proc);

	XtSetArg(args[0],XtNborderWidth, 1);
	XtSetArg(args[1],XtNfromHoriz,  step_button);
	XtSetArg(args[2],XtNfromVert,   NULL);
	XtSetArg(args[3],XtNvertDistance,150);
	XtSetArg(args[4],XtNhorizDistance,20);
	XtSetArg(args[5],XtNfont,	font_info2);
	key_button = XtCreateManagedWidget("Key", commandWidgetClass,
					control_widget, args, 6);
	XtAddCallback(key_button,XtNcallback,prepare_key);

	XtSetArg(args[0],XtNborderWidth, 1);
	XtSetArg(args[1],XtNfromHoriz,  key_button);
	XtSetArg(args[2],XtNfromVert,   NULL);
	XtSetArg(args[3],XtNvertDistance,150);
	XtSetArg(args[4],XtNhorizDistance,20);
	XtSetArg(args[5],XtNfont,	font_info2);
	subtree_button =  XtCreateManagedWidget("Subtree", commandWidgetClass,
					control_widget, args, 6);
	XtAddCallback(subtree_button,XtNcallback,subtree_notify_proc);

	XtSetArg(args[0],XtNborderWidth, 1);
	XtSetArg(args[1],XtNfromHoriz,  subtree_button);
	XtSetArg(args[2],XtNfromVert,   NULL);
	XtSetArg(args[3],XtNvertDistance,150);
	XtSetArg(args[4],XtNhorizDistance,20);
	XtSetArg(args[5],XtNfont,	font_info2);
	histogram_button = XtCreateManagedWidget("Histogram",commandWidgetClass,
					control_widget, args, 6);
	XtAddCallback(histogram_button,XtNcallback,hist_notify_proc);

	XtSetArg(args[0],XtNborderWidth, 2);
	XtSetArg(args[1],XtNfromHoriz,  histogram_button);
	XtSetArg(args[2],XtNfromVert,   NULL);
	XtSetArg(args[3],XtNvertDistance,150);
	XtSetArg(args[4],XtNhorizDistance,165);
	XtSetArg(args[5],XtNfont,	font_info2);
	quit_button = XtCreateManagedWidget("Quit", commandWidgetClass,
					control_widget, args, 6);
	XtAddCallback(quit_button,XtNcallback, quit_notify_proc);

	XtSetArg(args[0],XtNx,		100);
	XtSetArg(args[1],XtNy,		1);
	XtSetArg(args[2],XtNlabel,	stategraph_title);
	XtSetArg(args[3],XtNfont,	font_info);
	XtSetArg(args[4],XtNborderWidth,0);
	title = XtCreateManagedWidget("title", labelWidgetClass,
					control_widget, args, 5);

	XtSetArg(args[0],XtNfromHoriz,	NULL);
	XtSetArg(args[1],XtNhorizDistance,20);
	XtSetArg(args[2],XtNfromVert,	NULL);
	XtSetArg(args[3],XtNvertDistance,35);
	XtSetArg(args[4],XtNlabel,	"Directory: ");
	XtSetArg(args[5],XtNborderWidth,0);
	XtSetArg(args[6],XtNfont,	font_info2);
	dir_label = XtCreateManagedWidget("Directory", labelWidgetClass,
					control_widget, args, 7);

	directory_choice = XtCreateManagedWidget(".", commandWidgetClass,
					control_widget, NULL, 0);

	dir_shell = XtCreatePopupShell("directory",overrideShellWidgetClass,
					frame, NULL, 0);
	
	dir_pop = XtCreateManagedWidget("menu",boxWidgetClass,
					dir_shell, NULL, 0);

	XtSetArg(args[0],XtNfromHoriz,	NULL);
	XtSetArg(args[1],XtNhorizDistance,20);
	XtSetArg(args[2],XtNfromVert,	NULL);
	XtSetArg(args[3],XtNvertDistance,55);
	XtSetArg(args[4],XtNlabel,	"Trace file: ");
	XtSetArg(args[5],XtNborderWidth,0);
	XtSetArg(args[6],XtNfont,	font_info2);
	trace_label = XtCreateManagedWidget("Tracefile", labelWidgetClass,
					control_widget, args, 7);

	file_choice = XtCreateManagedWidget(".", commandWidgetClass,
					control_widget, NULL, 0);

	file_shell = XtCreatePopupShell("file",overrideShellWidgetClass,
					frame, NULL, 0);
	
	file_pop = XtCreateManagedWidget("menu",boxWidgetClass,
					file_shell, NULL, 0);

	file_table[0] = NULL;
	directory_table[0] = NULL;
	load_directory_table();
}

create_message_window()
{
	/* Create the Text SubWindow. */
	XtSetArg(args[0],XtNwidth,		565);
	XtSetArg(args[1],XtNheight,		100);
	XtSetArg(args[2],XtNfromVert,		control_widget);
	XtSetArg(args[3],XtNvertDistance,	5);
	XtSetArg(args[4],XtNfromHoriz,		NULL);
	XtSetArg(args[5],XtNhorizDistance,	0);
	XtSetArg(args[6],XtNborderWidth,	2);
	XtSetArg(args[7],XtNlength,		BUFFER_LENGTH);
	XtSetArg(args[8],XtNeditType,		XttextEdit);
	XtSetArg(args[9],XtNtextOptions,	
		(scrollOnOverflow | scrollVertical | wordBreak) );
	XtSetArg(args[10],XtNforeground,	black);
	XtSetArg(args[11],XtNbackground,	white);
	XtSetArg(args[12],XtNfont, font_info2);
#ifdef X11R3
	textsw = XtCreateManagedWidget("text", asciiStringWidgetClass,
					panel, args, 13);
#else
	textsw = XtCreateManagedWidget("text", asciiTextWidgetClass,
			panel, args, 13);
#endif
}

create_can_window()
{
	unsigned long event_mask;

	/* Create the panel sub-window and all of its goodies. */
	XtSetArg(args[0],XtNwidth,	560);
	XtSetArg(args[1],XtNheight,	178);
	XtSetArg(args[2],XtNfromHoriz,	NULL);
	XtSetArg(args[3],XtNfromVert,	textsw);
	XtSetArg(args[4],XtNborderWidth,1);
	outer_canvas = XtCreateManagedWidget("canvas",formWidgetClass,
					panel, args, 5);
	
	XtSetArg(args[0],XtNwidth,	VIEWWIDTH);
	XtSetArg(args[1],XtNheight,	VIEWHEIGHT);
	viewport = XtCreateManagedWidget("viewport", viewportWidgetClass,
					outer_canvas, args, 2);

	/* Create the Canvas SubWindow. */
	XtSetArg(args[0],XtNwidth,	VIEWWIDTH);
	XtSetArg(args[1],XtNheight,	VIEWHEIGHT);
	inner_canvas = XtCreateManagedWidget(NULL,formWidgetClass, viewport,
					args, 2);
	event_mask = ButtonPressMask;
	XtAddEventHandler(inner_canvas,event_mask,NULL,handle_pcevent,NULL);
}
	

create_overview_window()
{
	/* Create the Canvas subwindow to view the full tree */
	XtSetArg(args[0],XtNwidth,		384);
	XtSetArg(args[1],XtNheight,		283);
	XtSetArg(args[2],XtNfromHoriz,		control_widget);
	XtSetArg(args[3],XtNfromVert,		NULL);
	XtSetArg(args[4],XtNvertDistance,	5);
	XtSetArg(args[5],XtNhorizDistance,	8);
	canvas_full = XtCreateManagedWidget("overview", formWidgetClass,
					panel, args, 6);
	XtAddEventHandler(canvas_full,ButtonPressMask,
		NULL,handle_ovevent,NULL);

	/* create the misc SubWindow */
	XtSetArg(args[0],XtNx,			0);
	XtSetArg(args[1],XtNy,			300);
	misc_shell = XtCreatePopupShell("subwindow",overrideShellWidgetClass,
					frame, NULL, 0);
	
	XtSetArg(args[0],XtNwidth,		INFOX);
	XtSetArg(args[1],XtNheight,		INFOY);
	XtSetArg(args[2],XtNborderWidth,	2);
	misc_canvas = XtCreateManagedWidget("menu",formWidgetClass,
					misc_shell, args, 3);

	XtAddEventHandler(misc_canvas,ButtonPressMask,
		NULL,handle_miscevent,NULL);

	XtSetArg(args[0],XtNx, 		frame_x+50);
	XtSetArg(args[1],XtNy, 		frame_y+660);
	hist_shell = XtCreatePopupShell("hist_shell", wmShellWidgetClass, frame,
		args, 2);
} 

create_hist()
{
	unsigned long event_mask;

	XtSetArg(args[0],XtNheight,	220);
	XtSetArg(args[1],XtNwidth,	750);
	XtSetArg(args[2],XtNborderWidth,3);
	outer_hist = XtCreateManagedWidget("hist", formWidgetClass,
				hist_shell, args, 3);

	XtSetArg(args[0],XtNallowHoriz,	True);
	XtSetArg(args[1],XtNlength,	3000);
	XtSetArg(args[2],XtNthickness,	3000);
	XtSetArg(args[3],XtNborderWidth,3);
	hist_viewport = XtCreateManagedWidget( "hist_viewport",
		viewportWidgetClass,outer_hist,args, 4);
	XtSetArg(args[0], XtNforceBars, True);
	XtSetValues(hist_viewport,args, 1);


	XtSetArg(args[0],XtNheight,	220);
	XtSetArg(args[1],XtNwidth,	750);
	XtSetArg(args[2],XtNborderWidth,2);
	inner_hist = XtCreateManagedWidget( NULL, formWidgetClass,hist_viewport,
		args,3);
}


create_misc()
{

I 2
	unsigned long event_mask;

E 2
	XtSetArg(args[0],XtNlabel,	"Event Speed (%)");
	XtSetArg(args[1],XtNfromHoriz,	NULL);
	XtSetArg(args[2],XtNhorizDistance,20);
	XtSetArg(args[3],XtNfromVert,	NULL);
	XtSetArg(args[4],XtNvertDistance,79);
	XtSetArg(args[5],XtNborderWidth,0);
	XtSetArg(args[6],XtNfont,	font_info2);
	scrollbar_label = XtCreateManagedWidget(NULL,labelWidgetClass,
		control_widget, args, 7);

	XtSetArg(args[0],XtNfromHoriz,	NULL);
	XtSetArg(args[1],XtNhorizDistance,170);
	XtSetArg(args[2],XtNfromVert,	NULL);
	XtSetArg(args[3],XtNvertDistance,80);
	XtSetArg(args[4],XtNlength,	300);
	XtSetArg(args[5],XtNthickness,	14);
	XtSetArg(args[6],XtNorientation,XtorientHorizontal);
	XtSetArg(args[7],XtNtop, 	.00);
	XtSetArg(args[8],XtNshown, 	1.00);
	e_speed_slider = XtCreateManagedWidget(NULL, scrollbarWidgetClass,
			control_widget, args, 9);
	/* pull this line out once scrollbars don't core dump
	XtAddCallback(e_speed_slider,XtNscrollProc,e_speed_notify_proc); */
	XtAddCallback(e_speed_slider,XtNthumbProc,e_speed_notify_thumb);
#ifdef X11R3
	XtScrollBarSetThumb(e_speed_slider,0.00,(float)0.75);
#else
	XawScrollbarSetThumb(e_speed_slider,0.00,(float)0.75);
#endif

	/* create the popup shell and popup widget here */
	XtSetArg(args[0],XtNx, 		frame_x+660);
	XtSetArg(args[1],XtNy, 		frame_y+50);
	key_shell = XtCreatePopupShell("key_shell",wmShellWidgetClass,
					frame,args, 2);

	/* Create the PopUp window for the key */
	XtSetArg(args[0],XtNwidth, 	420);
	XtSetArg(args[1],XtNheight, 800);
	XtSetArg(args[2],XtNx, 		50);
	XtSetArg(args[3],XtNy, 		660);
	XtSetArg(args[4],XtNlabel,	key_title);
	key_pop = XtCreateManagedWidget("keyWindow", formWidgetClass,
					key_shell, args, 5);

	/* Create the popup shell for the subtree */
	XtSetArg(args[0],XtNx, 		frame_x+0);
	XtSetArg(args[1],XtNy, 		frame_y+575);
	subtree_shell = XtCreatePopupShell("subtree_shell",wmShellWidgetClass,
					frame,args, 2);

	XtSetArg(args[0],XtNwidth,	960);
	XtSetArg(args[1],XtNheight,	300);
	XtSetArg(args[2],XtNx,		0);
	XtSetArg(args[3],XtNy,		575);
	XtSetArg(args[4],XtNlabel,	"             Subtree Canvas");
	outer_subtree = XtCreateManagedWidget("subwindow", formWidgetClass,
					subtree_shell, args, 5);

	XtSetArg(args[0],XtNallowHoriz,	True);
	XtSetArg(args[1],XtNlength,	3000);
	XtSetArg(args[2],XtNthickness,	3000);
	XtSetArg(args[3],XtNborderWidth,3);
	XtSetArg(args[4],XtNallowVert,	True);
	subtree_viewport = XtCreateManagedWidget( "subtree_viewport",
		viewportWidgetClass,outer_subtree,args, 5);
	XtSetArg(args[0], XtNforceBars, True);
	XtSetValues(subtree_viewport,args, 1);

	/* Create the PopUp window for the subtree */
	/* this should eventually have scrollbars */
	XtSetArg(args[0],XtNwidth,	960);
	XtSetArg(args[1],XtNheight,	300);
	XtSetArg(args[2],XtNx,		0);
	XtSetArg(args[3],XtNy,		575);
	XtSetArg(args[4],XtNlabel,	"             Subtree Canvas");
	subtree_frame = XtCreateManagedWidget("subwindow", formWidgetClass,
					subtree_viewport, args, 5);

	/* Create the popup shell for the node info */
	XtSetArg(args[0],XtNx, 		0);
	XtSetArg(args[1],XtNy, 		575);
	misc_shell = XtCreatePopupShell("nodeInfo",overrideShellWidgetClass,
					frame,args, 2);

	/* Create the PopUp window for node info and other misc. items */
	XtSetArg(args[0],XtNwidth,	INFOX);
	XtSetArg(args[1],XtNheight,	INFOY);
	misc_frame = XtCreateManagedWidget("misc window", formWidgetClass,
					misc_shell, args, 2);

	/* Create node popup shell. */
	XtSetArg(args[0],XtNx,		300);
	XtSetArg(args[1],XtNy,		300);
	XtSetArg(args[2],XtNborderWidth,2);
	node_shell = XtCreatePopupShell("nodeShell",overrideShellWidgetClass,
					frame,args, 3);

	/* Create the node window form. */
	XtSetArg(args[0],XtNwidth,	130);
	XtSetArg(args[1],XtNheight,	200);
	XtSetArg(args[2],XtNborderWidth,2);
	node_pop = XtCreateManagedWidget("nodeWindow", formWidgetClass,
					node_shell, args, 3);

I 2


	/*  Keep buttonpress events from being delivered to the root window */
	event_mask = ButtonPressMask;
	XtAddEventHandler(node_pop,event_mask,NULL,popdummy,NULL);


E 2
	/* Create quit popup shell. */
	XtSetArg(args[0],XtNx,		frame_x+483);
	XtSetArg(args[1],XtNy,		frame_y+169);
	XtSetArg(args[2],XtNborderWidth,4);
	quit_shell = XtCreatePopupShell("quitShell",overrideShellWidgetClass,
					frame,args, 3);

	/* Create the quit window form. */
	quit_pop = XtCreateManagedWidget("quitWindow", formWidgetClass,
					quit_shell, NULL, 0);
I 2


	/*  Keep buttonpress events from being delivered to the root window */
	event_mask = ButtonPressMask;
	XtAddEventHandler(quit_pop,event_mask,NULL,popdummy,NULL);
E 2

	/* Create the quit question. */
	XtSetArg(args[0],XtNlabel,	"Do you really want to quit?");
	XtSetArg(args[1],XtNborderWidth,0);
	XtSetArg(args[2],XtNfromVert,	NULL);
	XtSetArg(args[3],XtNvertDistance,NULL);
	XtSetArg(args[4],XtNfont,	font_info2);
	quit_question = XtCreateManagedWidget(NULL, labelWidgetClass,
					quit_pop, args, 5);

	/* Create the quit quit button. */
	XtSetArg(args[0],XtNlabel,	"Yes ");
	XtSetArg(args[1],XtNborderWidth,1);
	XtSetArg(args[2],XtNfromVert,	NULL);
	XtSetArg(args[3],XtNvertDistance,30);
	XtSetArg(args[4],XtNhorizDistance,20);
	XtSetArg(args[5],XtNfont,	font_info2);
	quit_execute_button = XtCreateManagedWidget("quitWindow",
					commandWidgetClass, quit_pop,
					args, 6);
	XtAddCallback(quit_execute_button,XtNcallback,execQuit);

	/* Create the quit cancel button. */
	XtSetArg(args[0],XtNlabel,"No");
	XtSetArg(args[1],XtNfromHoriz,quit_execute_button);
	XtSetArg(args[2],XtNhorizDistance,50);
	XtSetArg(args[3],XtNborderWidth,1);
	XtSetArg(args[4],XtNfromVert,	NULL);
	XtSetArg(args[5],XtNvertDistance,30);
	XtSetArg(args[6],XtNfont,	font_info2);
	quit_cancel_button = XtCreateManagedWidget("quitWindow",
					commandWidgetClass, quit_pop, args, 7);
	XtAddCallback(quit_cancel_button,XtNcallback,cancelQuit);

}


dynamic_init()
{
}
#endif
E 1
