h07685
s 00137/00000/00000
d D 1.1 90/10/16 11:11:43 werner 1 0
c date and time created 90/10/16 11:11:43 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#endif
#ifdef X11
#include "xexterns.h"
#endif
#if sun
#include <sys/types.h>
#include <sys/file.h>
#endif
#if CRAY2 || CRAY
#include <fcntl.h>
#endif
#include <sys/stat.h>
#include "externvars.h"
#include "log_entry.h"

#define RMODE	0	/* read mode */

/**********************************************************************
 * Opens the trace file and deals with errors.
 *
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */
 

/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern errno;
#ifdef sunview
extern Frame frame;
#endif

open_tracefile(filename)
     char *filename;
{
    char str[30];
#ifdef CRAYTRACE
    char junkbuf[NB_THEADER];
#endif CRAYTRACE
    struct stat *buf;
    int nb;

    close(fp);		/* Close file from the last time */

    /* RETURNS:   0 - everything ok
                  1 - filename was null
		  2 - filename was a directory
		  3 - couldn't open filename to read  */

    if (filename == NULL) {
#ifdef sunview
	window_bell(frame);
#endif
#ifdef X11
	XBell(display_control,0);
#endif
	display_message("ERROR: No tracefile specified...\n");
	return(1);
    }  /* end if */
    /* want to be certain that have a FILE not a DIRECTORY, 
       therefore stat the file and check. */
    buf = (struct stat *)malloc(sizeof(struct stat));
    stat(filename,buf);
    if (buf->st_mode & S_IFDIR) {  /* have a directory */
#ifdef sunview
	window_bell(frame);
#endif
#ifdef X11
	XBell(display_control,0);
#endif
	display_message("ERROR: tracefile is a directory\n");
	return(2);
    }  /* end if */
    else     /* was not a directory */
	if ((fp = open(filename,O_RDONLY,RMODE)) == -1) {
	    char msg[50];
	
	    sprintf(str,"Couldn't open file <%s>\n",filename);
#ifdef sunview
	    window_bell(frame);
#endif
#ifdef X11
	XBell(display_control,0);
#endif
	    display_message(str);
	    return(3);
	}  /* end if */
	else {  /* have a good file */
	    display_message("Loading...\n");
	    filepresent = 1;

/* add in mode check to parse static tracefile for tree drawing */

	    initialize();
#ifdef CRAYTRACE
	    nb = read(fp,junkbuf,NB_THEADER);
	    if (nb == 0) {
		printf("End of tracefile - init\n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	    }
	    if (nb < 0) {
		printf("Read error on tracefile\n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	    }
#endif
	    display_message("select Go or Step to begin\n");
	    return(0);
	}  /* end else */
}   /* end open_tracefile */
E 1
