h53269
s 00368/00000/00000
d D 1.1 90/10/16 11:11:39 werner 1 0
c date and time created 90/10/16 11:11:39 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>
#include <suntool/scrollbar.h>
#include "externvars.h"

extern int errno,mode,subtree;
extern Frame popup_frame,subtree_frame,popup_key_frame,misc_frame;
extern Scrollbar h_bar;
extern Panel_item process_count, task_count;

int first_time = 1;		/* needed to set up first proc at init time*/

/**********************************************************************
 * This file contains the routines which handle the notifica-
 * tions from the various buttons on the panel: 
 * go_notify_proc, load_notify_proc, connect_notify_proc, 
 * path_notify_proc, key_notfy_proc, quit_notify_proc,
 * step_notify_proc, stop_notify_proc, subtree_notify_proc,
 * recover_notify_proc,
 * and the routine which handles notifications from the slider
 * on the panel:  e_speed_notify_proc, and the support function
 * do_wait that causes a wait of the specified amount of time.
 * Also file_notify_proc, directory_notify_proc.
 *
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */
 

/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

void load_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    int err;

    err = open_tracefile(file_table[ft_index+ft_val]);
    if (err != 0) display_message("Select another tracefile\n");
    first_time = 1;
    window_return( NOTIFY_DONE );
}

void go_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    extern Frame frame;
    char str[30];
    int err, x;

    
    window_set(misc_frame,WIN_SHOW,FALSE,0);	 /* hide the node info */
    if (done) {
	window_bell(frame);
	display_message("Have processed all events\n");
    }
    else if (filepresent) {
	go = 1;
	display_message("To Stop: Hit Left Mouse Button\n");
	/* Process each event in turn.  We terminate if the LEFT mouse button
	 * is held down by the user. */
	while (go && (data_input() != -1 ) ) {  
	    if (curr_id != 0 || curr_action == IDLE)  {  /* not a killer event */
		do_wait();  
		err = process_task();
		switch (err) {
		  case 0 : break;  /* all went well */
		  case 1 : 
#ifdef DEBUG
		    sprintf(str, "Task %d does not exist\n",curr_id);
		    display_message(str);
#endif
		    break;
		  case 2 : break;  /* non-significant action # */
		}	    
		sprintf(str,"Active Processes: %d",curr_procs);
		panel_set(process_count,PANEL_LABEL_STRING,str,0);
	    }
#ifdef LATER	/* this causes the hist to cardiac arrest on wrap arounds */
	    x = (SPACEHIST * curr_events);
	    if (x <= 700) x=0;
	    else x = x - 700;
	    scrollbar_scroll_to(h_bar,x);
#endif LATER
	    plot_histogram();  /* plot new info to histogram */
	}  
    }
    else {
	display_message("ERROR: No tracefile specified...\n");
	window_bell( frame );
    }
    window_return( NOTIFY_DONE );
}

button_hit()
/* This function returns zero if the LEFT mouse button has not been hit
 * and non-zero if it has.
 */
{

    /* Like wow man this did not work !!!
    extern Frame frame;
    Event next_event;
    
    if( !window_read_event( frame, &next_event ) ) {
        sprintf(str,"NOTIFY: error %d\n",errno );
	display_message(str);
	exit( 1 );
    }
    return( event_is_button( &next_event ) );
    */
    /* We now try working with the pannel window. */
    extern Panel panel;
    return( (int)window_get( panel, WIN_EVENT_STATE, MS_LEFT ) );
}

void quit_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    int doquit;

    doquit = confirm("Please verify your decision to quit");
    if (doquit) {
       done = 1;
       exit( NOTIFY_DONE );
    }
    else window_return( NOTIFY_DONE );
}


void connect_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    display_message("Will handle socket input\n");
    key_enable = 0;
    window_return( NOTIFY_DONE );
}

void subtree_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
/************************************************
 * Will cause subtree canvas to be displayed and
 * activated if it is not currently displayed
 * (and in dynamic mode the input must be done),
 * else will remove the display of the subtree
 * canvas.
 ************************************************/
    
    if ((mode == 1) && !done) {
	window_bell(frame);
	display_message("Cannot draw subtree until input completed\n");
    }
    else
      if (filepresent) 
	if (window_get(subtree_frame,WIN_SHOW)) {
	    subtree = 0;
	    window_set(subtree_frame,WIN_SHOW,FALSE,0);
	}  /* end if */
	else  {    
	    subtree = 1;
	    if (leftid == -1) {
		window_bell(frame);
		display_message("ERROR: No node is selected as the root\n");
	    }  /* end if */
	    else {
		window_set(subtree_frame,WIN_SHOW,TRUE,0);
		display_message("Preparing Subtree Canvas...\n");
		subtree_init(); 
	    }  /* end else */
	}  /* end else */
      else  {
	  display_message("ERROR: No tracefile specified...\n");
	  window_bell(frame);
      }  /* end else */
    window_return( NOTIFY_DONE );
}  /* end subtree_notify_proc */


void step_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    int err;
    char str[20];

    window_set(misc_frame,WIN_SHOW,FALSE,0);	 /* hide the node info */
    if (done) {
	window_bell(frame);
	display_message("Have processed all events\n");
    }
    else if (filepresent) {
	go = 0;
	if (data_input() != -1) {
		if (curr_id != 0 || curr_action == IDLE) {
		    err = process_task();
		    switch (err) {
		      case 0 : break;  /* all went well */
		      case 1 : 
			break;
		      case 2 : break;  /* non-significant action # */
		    }
		    sprintf(str,"Active Processes: %d",curr_procs);
		    panel_set(process_count,PANEL_LABEL_STRING,str,0);
		}
		plot_histogram();
	}
    }
    else   {
	display_message("ERROR: No tracefile specified...\n");
	window_bell(frame);
    }
    window_return( NOTIFY_DONE );
}   /* end step_notify_proc */

void path_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    if ((mode == 1) && !done) {
	window_bell(frame);
	display_message("Cannot draw path until input completed\n");
    }
    else {
	if (filepresent)
	  display_message("would draw calculated path\n");
	else  {
	    display_message("ERROR: No tracefile specified...\n");
	    window_bell(frame);
	}
    }
    window_return( NOTIFY_DONE );
}

key_notify_proc(item,event)
Panel_item item;
Event *event;
{
    if ((mode == 1) && (!key_enable)) {
	window_bell(frame);
	display_message("Cannot display key until input completed\n");
    }
    else
      if (window_get(popup_key_frame,WIN_SHOW))
	window_set(popup_key_frame,WIN_SHOW,FALSE,0);
    else
      window_set(popup_key_frame,WIN_SHOW,TRUE,0);
    window_return( NOTIFY_DONE );
}

void hist_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
/*******************************************
 * Will cause histogram to be displayed if 
 * it is not displayed already - else will
 * remove the histogram display.
 ******************************************/
    int x;   /* where to s<croll to */

    if (window_get(popup_frame,WIN_SHOW))
      window_set(popup_frame,WIN_SHOW,FALSE,0);
    else {
	window_set(popup_frame,WIN_SHOW,TRUE,0);
	x = (SPACEHIST * curr_events);
	if (x<=100) x=0;
	else x = x - 100;
	scrollbar_scroll_to(h_bar,x);
    }
    window_return(NOTIFY_DONE);
}

void e_speed_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    e_speed = value;
    window_return( NOTIFY_DONE );
}


do_wait()
{
/***********************************************
 * handles the wait - the maximum wait is
 * MAXWAIT microseconds, and the minimum wait is
 * zero.  The wait will not be exactly MAXWAIT
 * microseconds - rather MAXWAIT is used to 
 * control the spin-wait.   We would have 
 * preferred to avoid a spin-wait - yet wanted
 * to check for mouse input to stop the wait.
 * The Event Speed Slider represents
 * the percentage of maximum speed - thus 
 * 100 means to run as fast as possible.
 **********************************************/
    int num,i;			

    num = ((100 - e_speed) * .01 * MAXWAIT);

    for (i=0; i != num && !button_hit(); i++);
    if( button_hit() ) go = 0;

}
    

    

void file_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    ft_val = value;
    if( value >= 31 )
        load_file_table(".");
    window_return( NOTIFY_DONE );
}

void directory_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    extern errno;
    char str[56];

    dt_index += value;
    if ((value+1) % 32) {
	if (chdir(directory_table[dt_index]) == -1) {
		sprintf(str,"WARNING: chdir failed, errno = %d\n", errno);
		display_message(str);
	} else {
		dt_index = 0;
		load_directory_table();
	}
    } else {
	load_directory_table();
    }
    window_return( NOTIFY_DONE );
}
#endif
E 1
