#include "Bdef.h"


#if (INTFACE == C_CALL)
void Ccgsum2d(ConTxt, scope, top, m, n, A, lda, rdest, cdest)
int  ConTxt;
char  *scope;
char  *top;
int  m;
int  n;
float  *A;
int  lda;
int  rdest;
int  cdest;
#else
void cgsum2d_(ConTxt, scope, top, m, n, A, lda, rdest, cdest)
int  *ConTxt;
char  *scope;
char  *top;
int  *m;
int  *n;
float  *A;
int  *lda;
int  *rdest;
int  *cdest;
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Combine sum operation for complex rectangular matrices.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  SCOPE   (input) Ptr to char
 *          Limit the scope of the operation.
 *          = 'R' :   Operation is performed by a process row.
 *          = 'C' :   Operation is performed by a process column.
 *          = 'A' :   Operation is performed by all processes in grid.
 *
 *  TOP     (input) Ptr to char
 *          Controls fashion in which messages flow within the operation.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to complex two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *  RDEST   (input) Ptr to int
 *          The process row of the destination of the sum.
 *          If rdest == -1, then result is left on all processes in scope.
 *
 *  CDEST   (input) Ptr to int
 *          The process column of the destination of the sum.
 *          If rdest == -1, then CDEST ignored.
 *
 * ------------------------------------------------------------------------
 */
{
   void GetCombBuff();
   void tree_comb();
   void RepTreeComb();
   void BE_comb();
   void cvvsum();
   void mvcopy8();
   void vmcopy8();
   char *getbuff();
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
/*
 *  Variable Declarations
 */
   BLACBUFF *bp=NULL, *bp2;
   BLACSCONTEXT *ctxt;
   char ttop, tscope;
   int N, length, tlda, trdest;
   extern BLACBUFF AuxBuff00;

   MGetConTxt(Mpval(ConTxt), ctxt);
   ttop = Mlowcase(*top);
   tscope = Mlowcase(*scope);

   if (Mpval(cdest) == -1) trdest = -1;
   else trdest = Mpval(rdest);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_COMB, __FILE__, tscope, 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, &trdest, Mpaddress(cdest));
#endif
   if (Mpval(lda) >= Mpval(m)) tlda = Mpval(lda);
   else tlda = Mpval(m);

   N = Mpval(m) * Mpval(n);
   length = N * sizeof(SCOMPLEX);
   if ( (Mpval(m) == tlda) || (Mpval(n) == 1) )
   {
      bp = (BLACBUFF *) A;
      GetCombBuff(length, &bp, &bp2);
   }
   else
   {
      GetCombBuff(length, &bp, &bp2);
      cmvcopy(Mpval(m), Mpval(n), A, tlda, bp->Buff);
   }

   if (ctxt->TopsRepeat) 
   {
      if ( (trdest != -1) || (ctxt->TopsCohrnt) ) ttop = '$';
      else if ( (ttop != ' ') && (ttop != 'h') ) ttop = '$';
   }
   switch(ttop)
   {
   case ' ':
      if ( (trdest == -1) && !(ctxt->TopsCohrnt) )
         BE_comb(ctxt, tscope, N, length, bp, bp2, cvvsum);
      else
         tree_comb(ctxt, tscope, 2, N, length, bp, bp2, trdest,
                   Mpval(cdest), cvvsum);
      break;
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      tree_comb(ctxt, tscope, ttop-47, N, length, bp, bp2, trdest,
                Mpval(cdest), cvvsum);
      break;
   case 'f':
      tree_comb(ctxt, tscope, FULLCON, N, length, bp, bp2, trdest,
                Mpval(cdest), cvvsum);
      break;
   case 't':
      tree_comb(ctxt, tscope, ctxt->Nb_co, N, length, bp, bp2,
                trdest, Mpval(cdest), cvvsum);
      break;
   case '$':
      RepTreeComb(ctxt, tscope, N, length, bp, bp2, trdest, Mpval(cdest),
                  cvvsum);
      break;
   case 'h':
/*
 *    Use bidirectional exchange if everyone wants answer
 */
      if ( (trdest == -1) && !(ctxt->TopsCohrnt) )
         BE_comb(ctxt, tscope, N, length, bp, bp2, cvvsum);
      else
         tree_comb(ctxt, tscope, 2, N, length, bp, bp2, trdest,
                   Mpval(cdest), cvvsum);
      break;
   default :
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown topology '%c'",*top);
   }

/*
 * If I am selected to receive answer
 */
   if ( ( (ctxt->myrow == trdest) && (ctxt->mycol == Mpval(cdest)) ) ||
        (trdest == -1) )
   {
/*
 *    Unpack the sum array
 */
      if (bp->Buff != (char *) A)
         cvmcopy(Mpval(m), Mpval(n), A, tlda, bp->Buff);
   }
}
