#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cblacs_gridinit(ConTxt, order, nprow, npcol)
int  *ConTxt;
char  *order;
int  nprow;
int  npcol;
#else
void blacs_gridinit_(ConTxt, order, nprow, npcol)
int  *ConTxt;
char  *order;
int  *nprow;
int  *npcol;
#endif
{
#if (INTFACE == C_CALL)
   void Cblacs_gridmap();
#else
   void blacs_gridmap_();
#endif
   int *tmpgrid, *iptr;
   int i, j;

/*
 * Grid can be row- or column-major natural ordering when blacs_gridinit is
 * called.  Define a tmpgrid to reflect this, and call blacs_gridmap to
 * set it up
 */
   iptr = tmpgrid = (int*) malloc( Mpval(nprow)*Mpval(npcol)*sizeof(*tmpgrid) );
   if (Mlowcase(*order) == 'c')
   {
      i = Mpval(npcol) * Mpval(nprow);
      for (j=0; j < i; j++) iptr[j] = j;
   }
   else
   {
      for (j=0; j < Mpval(npcol); j++)
      {
         for (i=0; i < Mpval(nprow); i++) iptr[i] = i * Mpval(npcol) + j;
         iptr += Mpval(nprow);
      }
   }
#if (INTFACE == C_CALL)
   Cblacs_gridmap(ConTxt, tmpgrid, nprow, nprow, npcol);
#else
   blacs_gridmap_(ConTxt, tmpgrid, nprow, nprow, npcol);
#endif
   free(tmpgrid);
}
